/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.convert;

import com.tngtech.junit.dataprovider.convert.AbstractObjectConverter;
import java.lang.reflect.Array;

public class ObjectArrayConverter
extends AbstractObjectConverter<Object[]> {
    @Override
    public Object[] convert(Object[] data, boolean isVarargs, Class<?>[] parameterTypes) {
        Object[] result;
        if (isVarargs) {
            result = new Object[parameterTypes.length];
            int lastArgIdx = parameterTypes.length - 1;
            if (lastArgIdx >= 0) {
                System.arraycopy(data, 0, result, 0, lastArgIdx);
            }
            result[lastArgIdx] = this.convertVararg(data, parameterTypes[lastArgIdx].getComponentType(), lastArgIdx);
        } else {
            result = data;
        }
        this.checkIfArgumentsMatchParameterTypes(result, parameterTypes);
        return result;
    }

    private Object convertVararg(Object[] data, Class<?> varargComponentType, int nonVarargParameterCount) {
        if (data.length > 0) {
            Class<?> lastArgType;
            Object date = data[data.length - 1];
            Class<?> clazz = lastArgType = date != null ? date.getClass() : null;
            if (lastArgType != null && lastArgType.isArray() && lastArgType.getComponentType() == varargComponentType) {
                return date;
            }
        }
        Object varargArray = Array.newInstance(varargComponentType, data.length - nonVarargParameterCount);
        for (int idx = nonVarargParameterCount; idx < data.length; ++idx) {
            Array.set(varargArray, idx - nonVarargParameterCount, data[idx]);
        }
        return varargArray;
    }
}

