/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import com.tngtech.java.junit.dataprovider.Placeholders;
import com.tngtech.java.junit.dataprovider.common.Preconditions;
import com.tngtech.java.junit.dataprovider.format.DataProviderPlaceholderFormatter;
import com.tngtech.junit.dataprovider.format.DataProviderTestNameFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.runners.model.FrameworkMethod;

public class DataProviderFrameworkMethod
extends FrameworkMethod {
    final int idx;
    final Object[] parameters;
    final String nameFormat;
    final Class<? extends DataProviderTestNameFormatter> nameFormatter;

    public DataProviderFrameworkMethod(Method method, int idx, Object[] parameters, String nameFormat) {
        this(method, idx, parameters, nameFormat, null);
    }

    public DataProviderFrameworkMethod(Method method, int idx, Object[] parameters, String nameFormat, Class<? extends DataProviderTestNameFormatter> nameFormatter) {
        super(method);
        Preconditions.checkNotNull(parameters, "parameter must not be null");
        Preconditions.checkNotNull(nameFormat, "nameFormat must not be null");
        Preconditions.checkArgument(parameters.length != 0, "parameter must not be empty");
        this.idx = idx;
        this.parameters = Arrays.copyOf(parameters, parameters.length);
        this.nameFormat = nameFormat;
        this.nameFormatter = nameFormatter;
    }

    public String getName() {
        if (this.nameFormatter == null || DataProviderPlaceholderFormatter.class.equals(this.nameFormatter)) {
            return new DataProviderPlaceholderFormatter(this.nameFormat, Placeholders.all()).format(this.getMethod(), this.idx, Arrays.asList(this.parameters));
        }
        try {
            return this.nameFormatter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).format(this.getMethod(), this.idx, Arrays.asList(this.parameters));
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(String.format("Could not instantiate name formatter using default constructor '%s'.", this.nameFormatter), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Default constructor not accessable of name formatter '%s'.", this.nameFormatter), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Default constructor of name formatter '%s' has thrown: %s", this.nameFormatter, e.getMessage()), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Default constructor not found for name formatter '%s'.", this.nameFormatter), e);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unexpected exception while finding and invoking default constructor of name formatter '%s': %s", this.nameFormatter, e.getMessage()), e);
        }
    }

    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        return super.invokeExplosively(target, this.parameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.idx;
        result = 31 * result + (this.nameFormat == null ? 0 : this.nameFormat.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataProviderFrameworkMethod other = (DataProviderFrameworkMethod)((Object)obj);
        if (this.idx != other.idx) {
            return false;
        }
        if (this.nameFormat == null ? other.nameFormat != null : !this.nameFormat.equals(other.nameFormat)) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }
}

