/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.placeholder;

import com.tngtech.junit.dataprovider.placeholder.AbstractArgumentPlaceholder;
import com.tngtech.junit.dataprovider.placeholder.ReplacementData;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class NamedArgumentPlaceholder
extends AbstractArgumentPlaceholder {
    private static final Logger logger = Logger.getLogger(NamedArgumentPlaceholder.class.getName());

    public NamedArgumentPlaceholder() {
        super("%na\\[(-?[0-9]+|-?[0-9]+\\.\\.-?[0-9]+)\\]");
    }

    protected String getReplacementFor(String placeholder, ReplacementData data) {
        AbstractArgumentPlaceholder.FromAndTo fromAndTo = this.calcFromAndToForSubscriptAndArguments(placeholder, 4, data.getArguments().size());
        return this.formatAll(this.getSubArrayOfMethodParameters(data.getTestMethod(), fromAndTo), data.getArguments().subList(fromAndTo.from, fromAndTo.to));
    }

    protected String formatAll(Parameter[] parameters, List<Object> arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int idx = 0; idx < arguments.size(); ++idx) {
            String parameterName = parameters.length > idx ? parameters[idx].getName() : "?";
            Object argument = arguments.get(idx);
            stringBuilder.append(parameterName).append("=").append(this.format(argument));
            if (idx >= arguments.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private Parameter[] getSubArrayOfMethodParameters(Method testMethod, AbstractArgumentPlaceholder.FromAndTo fromAndTo) {
        Parameter[] parameters = testMethod.getParameters();
        if (parameters.length > 0 && !parameters[0].isNamePresent()) {
            logger.warning(String.format("Parameter names on method '%s' are not available. To store formal parameter names, compile the source file with the '-parameters' option. See also https://docs.oracle.com/javase/tutorial/reflect/member/methodparameterreflection.html", testMethod));
        }
        return Arrays.copyOfRange(parameters, fromAndTo.from, fromAndTo.to);
    }
}

