/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html5;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.report.model.Tag;
import java.util.Map;

public class TagFile {
    private Map<String, Tag> tagTypeMap = Maps.newLinkedHashMap();
    private Map<String, TagInstance> tags = Maps.newLinkedHashMap();

    public void fill(Map<String, Tag> tagIdMap) {
        for (Map.Entry<String, Tag> entry : tagIdMap.entrySet()) {
            Tag tag = entry.getValue().copy();
            tag.setValue((String)null);
            if (!this.tagTypeMap.containsKey(tag.getFullType())) {
                this.tagTypeMap.put(tag.getFullType(), tag);
            }
            TagInstance instance = new TagInstance();
            instance.tagType = tag.getFullType();
            instance.value = entry.getValue().getValueString();
            if (!Objects.equal((Object)entry.getValue().getDescription(), (Object)this.tagTypeMap.get(tag.getFullType()).getDescription())) {
                instance.description = entry.getValue().getDescription();
            }
            if (!Objects.equal((Object)entry.getValue().getHref(), (Object)this.tagTypeMap.get(tag.getFullType()).getHref())) {
                instance.href = entry.getValue().getHref();
            }
            this.tags.put(entry.getKey(), instance);
        }
    }

    private static class TagInstance {
        String tagType;
        String value;
        String description;
        String href;

        private TagInstance() {
        }
    }
}

