/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal.convert;

import com.tngtech.java.junit.dataprovider.DataProvider;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;

public class StringConverter {
    protected static final Object OBJECT_NO_CONVERSION = new Object();

    public Object[] convert(String data, boolean isVarArgs, Class<?>[] parameterTypes, DataProvider dataProvider, int rowIdx) {
        if (data == null) {
            return new Object[]{null};
        }
        if (parameterTypes.length == 1) {
            if (isVarArgs) {
                if (data.isEmpty()) {
                    return new Object[]{Array.newInstance(parameterTypes[0].getComponentType(), 0)};
                }
            } else {
                return new Object[]{this.convertValue(data, parameterTypes[0], dataProvider)};
            }
        }
        String[] splitData = this.splitBy(data, dataProvider.splitBy());
        this.checkArgumentsAndParameterCount(splitData.length, parameterTypes.length, isVarArgs, rowIdx);
        return this.convert(splitData, isVarArgs, parameterTypes, dataProvider);
    }

    protected String[] splitBy(String data, String regex) {
        String[] splitData = (data + "\u0000").split(regex);
        int lastItemIdx = splitData.length - 1;
        splitData[lastItemIdx] = splitData[lastItemIdx].substring(0, splitData[lastItemIdx].length() - 1);
        return splitData;
    }

    protected void checkArgumentsAndParameterCount(int argCount, int paramCount, boolean isVarArgs, int rowIdx) {
        if (isVarArgs && paramCount - 1 > argCount || !isVarArgs && paramCount != argCount) {
            throw new IllegalArgumentException(String.format("Test method expected %s %d parameters but got %d from @DataProvider row %d", isVarArgs ? "at least " : "", paramCount - 1, argCount, rowIdx));
        }
    }

    private Object[] convert(String[] splitData, boolean isVarArgs, Class<?>[] parameterTypes, DataProvider dataProvider) {
        Object[] result = new Object[parameterTypes.length];
        int nonVarArgParametersLength = parameterTypes.length - (isVarArgs ? 1 : 0);
        for (int idx = 0; idx < nonVarArgParametersLength; ++idx) {
            result[idx] = this.convertValue(splitData[idx], parameterTypes[idx], dataProvider);
        }
        if (isVarArgs) {
            Class<?> varArgComponentType = parameterTypes[nonVarArgParametersLength].getComponentType();
            Object varArgArray = Array.newInstance(varArgComponentType, splitData.length - parameterTypes.length + 1);
            for (int idx = nonVarArgParametersLength; idx < splitData.length; ++idx) {
                Array.set(varArgArray, idx - nonVarArgParametersLength, this.convertValue(splitData[idx], varArgComponentType, dataProvider));
            }
            result[nonVarArgParametersLength] = varArgArray;
        }
        return result;
    }

    private Object convertValue(String data, Class<?> targetType, DataProvider dataProvider) {
        String str;
        String string = str = dataProvider.trimValues() ? data.trim() : data;
        if (dataProvider.convertNulls() && "null".equals(str)) {
            return null;
        }
        Object tmp = this.customConvertValue(str, targetType, dataProvider);
        if (tmp != OBJECT_NO_CONVERSION) {
            return tmp;
        }
        if (String.class.equals(targetType)) {
            return str;
        }
        Object primaryOrWrapper = this.convertPrimaryOrWrapper(str, targetType);
        if (primaryOrWrapper != null) {
            return primaryOrWrapper;
        }
        if (targetType.isEnum()) {
            Class<Enum> enumType = targetType;
            return this.convertToEnumValue(str, enumType, dataProvider.ignoreEnumCase());
        }
        if (Class.class.equals(targetType)) {
            try {
                return Class.forName(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Unable to instantiate %s for '%s'", targetType.getSimpleName(), str), e);
            }
        }
        Object result = this.tryConvertUsingSingleStringParamConstructor(str, targetType);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("'" + targetType.getSimpleName() + "' is not supported as parameter type of test methods. Supported types are primitive types and their wrappers, case-sensitive 'Enum' values, 'String's, and types having a single 'String' parameter constructor.");
    }

    protected Object customConvertValue(String str, Class<?> targetType, DataProvider dataProvider) {
        return OBJECT_NO_CONVERSION;
    }

    protected Object convertPrimaryOrWrapper(String str, Class<?> targetType) {
        try {
            if (Boolean.TYPE.equals(targetType) || Boolean.class.equals(targetType)) {
                return Boolean.valueOf(str);
            }
            if (Byte.TYPE.equals(targetType) || Byte.class.equals(targetType)) {
                return Byte.valueOf(str);
            }
            if (Character.TYPE.equals(targetType) || Character.class.equals(targetType)) {
                if (str.length() == 1) {
                    return Character.valueOf(str.charAt(0));
                }
                throw new IllegalArgumentException(String.format("'%s' cannot be converted to %s.", str, targetType.getSimpleName()));
            }
            if (Short.TYPE.equals(targetType) || Short.class.equals(targetType)) {
                return Short.valueOf(str);
            }
            if (Integer.TYPE.equals(targetType) || Integer.class.equals(targetType)) {
                return Integer.valueOf(str);
            }
            if (Long.TYPE.equals(targetType) || Long.class.equals(targetType)) {
                return this.convertToLong(str);
            }
            if (Float.TYPE.equals(targetType) || Float.class.equals(targetType)) {
                return Float.valueOf(str);
            }
            if (Double.TYPE.equals(targetType) || Double.class.equals(targetType)) {
                return Double.valueOf(str);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to %s", str, targetType.getSimpleName()));
        }
        return null;
    }

    protected Object convertToLong(String str) {
        String longStr = str;
        if (longStr.endsWith("l")) {
            longStr = longStr.substring(0, longStr.length() - 1);
        }
        return Long.valueOf(longStr);
    }

    protected Object convertToEnumValue(String str, Class<Enum> enumType, boolean ignoreEnumCase) {
        String errorMessage = "'%s' is not a valid value of enum %s.";
        if (ignoreEnumCase) {
            for (Enum enumConstant : enumType.getEnumConstants()) {
                if (!str.equalsIgnoreCase(enumConstant.name())) continue;
                return enumConstant;
            }
        } else {
            try {
                Enum result = Enum.valueOf(enumType, str);
                return result;
            }
            catch (IllegalArgumentException e) {
                errorMessage = errorMessage + " Please be aware of case sensitivity or use 'ignoreEnumCase' of @" + DataProvider.class.getSimpleName() + ".";
            }
        }
        throw new IllegalArgumentException(String.format(errorMessage, str, enumType.getSimpleName()));
    }

    protected Object tryConvertUsingSingleStringParamConstructor(String str, Class<?> targetType) {
        for (Constructor<?> constructor : targetType.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !String.class.equals(constructor.getParameterTypes()[0])) continue;
            try {
                return constructor.newInstance(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Tried to invoke '%s' for argument '%s'. Exception: %s", constructor, str, e.getMessage()), e);
            }
        }
        return null;
    }
}

