/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderFilter;
import com.tngtech.java.junit.dataprovider.DataProviderMethodResolver;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import com.tngtech.java.junit.dataprovider.internal.DataConverter;
import com.tngtech.java.junit.dataprovider.internal.DefaultDataProviderMethodResolver;
import com.tngtech.java.junit.dataprovider.internal.TestGenerator;
import com.tngtech.java.junit.dataprovider.internal.TestValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class DataProviderRunner
extends BlockJUnit4ClassRunner {
    protected DataConverter dataConverter;
    protected TestGenerator testGenerator;
    protected TestValidator testValidator;
    List<FrameworkMethod> computedTestMethods;
    Map<FrameworkMethod, List<FrameworkMethod>> dataProviderMethods;

    public DataProviderRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        this.initializeHelpers();
        super.collectInitializationErrors(errors);
    }

    protected void initializeHelpers() {
        this.dataConverter = new DataConverter();
        this.testGenerator = new TestGenerator(this.dataConverter);
        this.testValidator = new TestValidator(this.dataConverter);
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (errors.isEmpty() && this.computeTestMethods().size() == 0) {
            errors.add(new Exception("No runnable methods"));
        }
    }

    protected void validateTestMethods(List<Throwable> errors) {
        if (errors == null) {
            throw new NullPointerException("errors must not be null");
        }
        for (FrameworkMethod testMethod : this.getTestClassInt().getAnnotatedMethods(Test.class)) {
            this.testValidator.validateTestMethod(testMethod, errors);
        }
        for (FrameworkMethod testMethod : this.getTestClassInt().getAnnotatedMethods(UseDataProvider.class)) {
            List<FrameworkMethod> dataProviderMethods = this.getDataProviderMethods(testMethod);
            if (dataProviderMethods.isEmpty()) {
                Object[] resolvers = ((UseDataProvider)testMethod.getAnnotation(UseDataProvider.class)).resolver();
                String message = "No valid dataprovider found for test '" + testMethod.getName() + "' using ";
                message = resolvers.length == 1 && DefaultDataProviderMethodResolver.class.equals(resolvers[0]) ? message + "the default resolver. By convention the dataprovider method name must either be equal to the test methods name, have a certain replaced or additional prefix (see JavaDoc of " + DefaultDataProviderMethodResolver.class + " or is explicitely set by @UseDataProvider#value()" : message + "custom resolvers: " + Arrays.toString(resolvers) + ". Please examine their javadoc and / or implementation.";
                errors.add(new Exception(message));
                continue;
            }
            for (FrameworkMethod dataProviderMethod : dataProviderMethods) {
                DataProvider dataProvider = (DataProvider)dataProviderMethod.getAnnotation(DataProvider.class);
                if (dataProvider == null) {
                    throw new IllegalStateException(String.format("@%s annotation not found on dataprovider method %s", DataProvider.class.getSimpleName(), dataProviderMethod.getName()));
                }
                this.testValidator.validateDataProviderMethod(dataProviderMethod, dataProvider, errors);
            }
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.computedTestMethods == null) {
            this.computedTestMethods = this.generateExplodedTestMethodsFor(super.computeTestMethods());
        }
        return this.computedTestMethods;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        if (filter == null) {
            throw new NullPointerException("filter must not be null");
        }
        super.filter((Filter)new DataProviderFilter(filter));
    }

    TestClass getTestClassInt() {
        return this.getTestClass();
    }

    List<FrameworkMethod> generateExplodedTestMethodsFor(List<FrameworkMethod> testMethods) {
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        if (testMethods == null) {
            return result;
        }
        for (FrameworkMethod testMethod : testMethods) {
            for (FrameworkMethod dataProviderMethod : this.getDataProviderMethods(testMethod)) {
                result.addAll(this.testGenerator.generateExplodedTestMethodsFor(testMethod, dataProviderMethod));
            }
        }
        return result;
    }

    List<FrameworkMethod> getDataProviderMethods(FrameworkMethod testMethod) {
        if (this.dataProviderMethods == null) {
            this.dataProviderMethods = new HashMap<FrameworkMethod, List<FrameworkMethod>>();
        }
        if (this.dataProviderMethods.containsKey(testMethod)) {
            return this.dataProviderMethods.get(testMethod);
        }
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        UseDataProvider useDataProvider = (UseDataProvider)testMethod.getAnnotation(UseDataProvider.class);
        if (useDataProvider == null) {
            result.add(null);
        } else {
            for (Class<? extends DataProviderMethodResolver> resolverClass : useDataProvider.resolver()) {
                DataProviderMethodResolver resolver = this.getResolverInstanceInt(resolverClass);
                List<FrameworkMethod> dataProviderMethods = resolver.resolve(testMethod, useDataProvider);
                if (UseDataProvider.ResolveStrategy.UNTIL_FIRST_MATCH.equals((Object)useDataProvider.resolveStrategy()) && !dataProviderMethods.isEmpty()) {
                    result.addAll(dataProviderMethods);
                    break;
                }
                if (!UseDataProvider.ResolveStrategy.AGGREGATE_ALL_MATCHES.equals((Object)useDataProvider.resolveStrategy())) continue;
                result.addAll(dataProviderMethods);
            }
        }
        this.dataProviderMethods.put(testMethod, result);
        return result;
    }

    DataProviderMethodResolver getResolverInstanceInt(Class<? extends DataProviderMethodResolver> resolverClass) {
        Constructor<? extends DataProviderMethodResolver> constructor;
        try {
            constructor = resolverClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find default constructor to instantiate resolver " + resolverClass, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Security violation while trying to access default constructor to instantiate resolver " + resolverClass, e);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access default constructor to instantiate resolver " + resolverClass, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate resolver " + resolverClass + " using default constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The default constructor of " + resolverClass + " has thrown an exception", e);
        }
    }
}

