/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class DataProviderFilter
extends Filter {
    static final Pattern DESCRIPTION_PATTERN = Pattern.compile("([^\\[\\] ]+)(\\[(\\d+):.*\\])?\\((.+)\\)$", 32);
    static final Pattern GENEROUS_DESCRIPTION_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}+)((.*))\\(((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\)$", 32);
    private static final int GROUP_METHOD_NAME = 1;
    private static final int GROUP_METHOD_PARAMS = 2;
    private static final int GROUP_METHOD_IDX = 3;
    private static final int GROUP_CLASS = 4;
    final Filter filter;

    public DataProviderFilter(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("supplied filter must not be null");
        }
        this.filter = filter;
    }

    public boolean shouldRun(Description description) {
        Matcher filterDescriptionMatcher = DESCRIPTION_PATTERN.matcher(this.filter.describe());
        if (!filterDescriptionMatcher.find()) {
            return this.filter.shouldRun(description);
        }
        String methodName = filterDescriptionMatcher.group(1);
        String className = filterDescriptionMatcher.group(4);
        if (description.isTest()) {
            return this.shouldRunTest(description, filterDescriptionMatcher, methodName, className);
        }
        for (Description each : description.getChildren()) {
            if (!this.shouldRun(each)) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        return this.filter.describe();
    }

    private boolean shouldRunTest(Description description, Matcher filterDescriptionMatcher, String methodName, String className) {
        Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(description.getDisplayName());
        if (!descriptionMatcher.matches()) {
            Matcher generousDescMatcher;
            if (filterDescriptionMatcher.group(3) == null && (generousDescMatcher = GENEROUS_DESCRIPTION_PATTERN.matcher(description.getDisplayName())).matches()) {
                return methodName.equals(generousDescMatcher.group(1)) && className.equals(generousDescMatcher.group(4));
            }
            return this.filter.shouldRun(description);
        }
        if (!methodName.equals(descriptionMatcher.group(1)) || !className.equals(descriptionMatcher.group(4))) {
            return false;
        }
        return filterDescriptionMatcher.group(2) == null || filterDescriptionMatcher.group(3).equals(descriptionMatcher.group(3));
    }
}

