/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.junit.AnalyzeClasses;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.junit.ArchTests;
import com.tngtech.archunit.junit.CacheMode;
import com.tngtech.archunit.junit.LocationProvider;
import com.tngtech.archunit.junit.engine_api.FieldSource;
import com.tngtech.archunit.junit.internal.AbstractArchUnitTestDescriptor;
import com.tngtech.archunit.junit.internal.ArchTestInitializationException;
import com.tngtech.archunit.junit.internal.ArchUnitEngineExecutionContext;
import com.tngtech.archunit.junit.internal.ClassAnalysisRequest;
import com.tngtech.archunit.junit.internal.ClassCache;
import com.tngtech.archunit.junit.internal.CreatesChildren;
import com.tngtech.archunit.junit.internal.DisplayNameResolver;
import com.tngtech.archunit.junit.internal.ElementResolver;
import com.tngtech.archunit.junit.internal.ReflectionUtils;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArchUnitTestDescriptor
extends AbstractArchUnitTestDescriptor
implements CreatesChildren {
    private static final Logger LOG = LoggerFactory.getLogger(ArchUnitTestDescriptor.class);
    static final String CLASS_SEGMENT_TYPE = "class";
    static final String FIELD_SEGMENT_TYPE = "field";
    static final String METHOD_SEGMENT_TYPE = "method";
    private final Class<?> testClass;
    private ClassCache classCache;

    private ArchUnitTestDescriptor(ElementResolver resolver, Class<?> testClass, ClassCache classCache) {
        super(resolver.getUniqueId(), testClass.getSimpleName(), (TestSource)ClassSource.from(testClass), testClass);
        this.testClass = testClass;
        this.classCache = classCache;
    }

    static void resolve(TestDescriptor parent, ElementResolver resolver, ClassCache classCache) {
        resolver.resolveClass().ifRequestedAndResolved(CreatesChildren::createChildren).ifRequestedButUnresolved((clazz, childResolver) -> ArchUnitTestDescriptor.createTestDescriptor(parent, classCache, clazz, childResolver));
    }

    private static void createTestDescriptor(TestDescriptor parent, ClassCache classCache, Class<?> clazz, ElementResolver childResolver) {
        if (clazz.getAnnotation(AnalyzeClasses.class) == null) {
            LOG.warn("Class {} is not annotated with @{} and thus cannot run as a top level test. This warning can be ignored if {} is only used as part of a rules library included via {}.in({}.class).", new Object[]{clazz.getName(), AnalyzeClasses.class.getSimpleName(), clazz.getSimpleName(), ArchTests.class.getSimpleName(), clazz.getSimpleName()});
            return;
        }
        ArchUnitTestDescriptor classDescriptor = new ArchUnitTestDescriptor(childResolver, clazz, classCache);
        parent.addChild((TestDescriptor)classDescriptor);
        classDescriptor.createChildren(childResolver);
    }

    @Override
    public void createChildren(ElementResolver resolver) {
        Supplier<JavaClasses> classes = () -> this.classCache.getClassesToAnalyzeFor(this.testClass, new JUnit5ClassAnalysisRequest(this.testClass));
        ReflectionUtils.getAllFields(this.testClass, ReflectionUtils.withAnnotation(ArchTest.class)).forEach(field -> this.resolveField(resolver, classes, new TestMember<Field>(this.testClass, (Field)field)));
        ReflectionUtils.getAllMethods(this.testClass, ReflectionUtils.withAnnotation(ArchTest.class)).forEach(method -> this.resolveMethod(resolver, classes, new TestMember<Method>(this.testClass, (Method)method)));
    }

    private void resolveField(ElementResolver resolver, Supplier<JavaClasses> classes, TestMember<Field> field) {
        resolver.resolveField((Field)field.member).ifUnresolved(childResolver -> ArchUnitTestDescriptor.resolveChildren((TestDescriptor)this, childResolver, field, classes));
    }

    private void resolveMethod(ElementResolver resolver, Supplier<JavaClasses> classes, TestMember<Method> method) {
        resolver.resolveMethod((Method)method.member).ifUnresolved(childResolver -> this.addChild((TestDescriptor)new ArchUnitMethodDescriptor(this.getUniqueId(), method, classes)));
    }

    private static void resolveChildren(TestDescriptor parent, ElementResolver resolver, TestMember<Field> field, Supplier<JavaClasses> classes) {
        if (ArchTests.class.isAssignableFrom(((Field)field.member).getType())) {
            ArchUnitTestDescriptor.resolveArchRules(parent, resolver, field, classes);
        } else {
            parent.addChild((TestDescriptor)new ArchUnitRuleDescriptor(resolver.getUniqueId(), (ArchRule)ArchUnitTestDescriptor.getValue(field), classes, field));
        }
    }

    private static <T> T getValue(TestMember<Field> field) {
        return ReflectionUtils.getValueOrThrowException((Field)field.member, field.owner, ArchTestInitializationException::new);
    }

    private static void resolveArchRules(TestDescriptor parent, ElementResolver resolver, TestMember<Field> field, Supplier<JavaClasses> classes) {
        DeclaredArchTests archTests = ArchUnitTestDescriptor.getDeclaredArchTests(field);
        resolver.resolveClass(archTests.getDefinitionLocation()).ifRequestedAndResolved(CreatesChildren::createChildren).ifRequestedButUnresolved((clazz, childResolver) -> {
            ArchUnitArchTestsDescriptor rulesDescriptor = new ArchUnitArchTestsDescriptor((ElementResolver)childResolver, archTests, classes, field);
            parent.addChild((TestDescriptor)rulesDescriptor);
            rulesDescriptor.createChildren((ElementResolver)childResolver);
        });
    }

    private static DeclaredArchTests getDeclaredArchTests(TestMember<Field> field) {
        return new DeclaredArchTests((ArchTests)ArchUnitTestDescriptor.getValue(field));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public void after(ArchUnitEngineExecutionContext context) {
        this.classCache.clear(this.testClass);
    }

    private static class TestMember<MEMBER extends AccessibleObject> {
        final Class<?> owner;
        final MEMBER member;

        TestMember(Class<?> owner, MEMBER member) {
            this.owner = owner;
            this.member = member;
        }

        String getName() {
            return ((Member)this.member).getName();
        }
    }

    private static class ArchUnitRuleDescriptor
    extends AbstractArchUnitTestDescriptor {
        private final ArchRule rule;
        private final Supplier<JavaClasses> classes;

        ArchUnitRuleDescriptor(UniqueId uniqueId, ArchRule rule, Supplier<JavaClasses> classes, TestMember<Field> field) {
            super(uniqueId, DisplayNameResolver.determineDisplayName(ArchUnitRuleDescriptor.formatWithPath(uniqueId, field.getName())), (TestSource)FieldSource.from((Field)((Field)field.member)), new AnnotatedElement[]{field.member});
            this.rule = rule;
            this.classes = classes;
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }

        public ArchUnitEngineExecutionContext execute(ArchUnitEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
            this.rule.check(this.classes.get());
            return context;
        }
    }

    private static class DeclaredArchTests {
        private final ArchTests archTests;

        DeclaredArchTests(ArchTests archTests) {
            this.archTests = archTests;
        }

        Class<?> getDefinitionLocation() {
            return this.archTests.getDefinitionLocation();
        }

        String getDisplayName() {
            return this.archTests.getDefinitionLocation().getSimpleName();
        }

        void handleFields(Consumer<? super Field> doWithField) {
            ReflectionUtils.getAllFields(this.archTests.getDefinitionLocation(), ReflectionUtils.withAnnotation(ArchTest.class)).forEach(doWithField);
        }

        void handleMethods(Consumer<? super Method> doWithMethod) {
            ReflectionUtils.getAllMethods(this.archTests.getDefinitionLocation(), ReflectionUtils.withAnnotation(ArchTest.class)).forEach(doWithMethod);
        }
    }

    private static class ArchUnitArchTestsDescriptor
    extends AbstractArchUnitTestDescriptor
    implements CreatesChildren {
        private final DeclaredArchTests archTests;
        private final Supplier<JavaClasses> classes;

        ArchUnitArchTestsDescriptor(ElementResolver resolver, DeclaredArchTests archTests, Supplier<JavaClasses> classes, TestMember<Field> field) {
            super(resolver.getUniqueId(), archTests.getDisplayName(), ArchUnitArchTestsDescriptor.noSource(), new AnnotatedElement[]{field.member, archTests.getDefinitionLocation()});
            this.archTests = archTests;
            this.classes = classes;
        }

        private static TestSource noSource() {
            return null;
        }

        @Override
        public void createChildren(ElementResolver resolver) {
            this.archTests.handleFields(field -> resolver.resolve(ArchUnitTestDescriptor.FIELD_SEGMENT_TYPE, field.getName(), childResolver -> this.resolveChildren((Field)field, (ElementResolver)childResolver)));
            this.archTests.handleMethods(method -> resolver.resolve(ArchUnitTestDescriptor.METHOD_SEGMENT_TYPE, method.getName(), childResolver -> this.addChild((Method)method)));
        }

        private void resolveChildren(Field field, ElementResolver childResolver) {
            ArchUnitTestDescriptor.resolveChildren((TestDescriptor)this, childResolver, new TestMember<Field>(this.archTests.getDefinitionLocation(), field), this.classes);
        }

        private void addChild(Method method) {
            this.addChild((TestDescriptor)new ArchUnitMethodDescriptor(this.getUniqueId(), new TestMember<Method>(this.archTests.getDefinitionLocation(), method), this.classes));
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.CONTAINER;
        }
    }

    private static class ArchUnitMethodDescriptor
    extends AbstractArchUnitTestDescriptor {
        private final TestMember<Method> method;
        private final Supplier<JavaClasses> classes;

        ArchUnitMethodDescriptor(UniqueId uniqueId, TestMember<Method> method, Supplier<JavaClasses> classes) {
            super(uniqueId.append(ArchUnitTestDescriptor.METHOD_SEGMENT_TYPE, ((Method)method.member).getName()), DisplayNameResolver.determineDisplayName(ArchUnitMethodDescriptor.formatWithPath(uniqueId, ((Method)method.member).getName())), (TestSource)MethodSource.from((Method)((Method)method.member)), new AnnotatedElement[]{method.member});
            this.validate((Method)method.member);
            this.method = method;
            this.classes = classes;
        }

        private void validate(Method method) {
            ArchTestInitializationException.check(method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JavaClasses.class), "@%s Method %s.%s must have exactly one parameter of type %s", ArchTest.class.getSimpleName(), method.getDeclaringClass().getSimpleName(), method.getName(), JavaClasses.class.getName());
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }

        public ArchUnitEngineExecutionContext execute(ArchUnitEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
            ReflectionUtils.invokeMethod((Method)this.method.member, this.method.owner, this.classes.get());
            return context;
        }
    }

    private static class JUnit5ClassAnalysisRequest
    implements ClassAnalysisRequest {
        private final AnalyzeClasses analyzeClasses;

        JUnit5ClassAnalysisRequest(Class<?> testClass) {
            this.analyzeClasses = JUnit5ClassAnalysisRequest.checkAnnotation(testClass);
        }

        private static AnalyzeClasses checkAnnotation(Class<?> testClass) {
            AnalyzeClasses analyzeClasses = testClass.getAnnotation(AnalyzeClasses.class);
            Preconditions.checkArgument((analyzeClasses != null ? 1 : 0) != 0, (String)"Class %s must be annotated with @%s", (Object)testClass.getSimpleName(), (Object)AnalyzeClasses.class.getSimpleName());
            return analyzeClasses;
        }

        @Override
        public String[] getPackageNames() {
            return this.analyzeClasses.packages();
        }

        @Override
        public Class<?>[] getPackageRoots() {
            return this.analyzeClasses.packagesOf();
        }

        @Override
        public Class<? extends LocationProvider>[] getLocationProviders() {
            return this.analyzeClasses.locations();
        }

        @Override
        public Class<? extends ImportOption>[] getImportOptions() {
            return this.analyzeClasses.importOptions();
        }

        @Override
        public CacheMode getCacheMode() {
            return this.analyzeClasses.cacheMode();
        }

        @Override
        public boolean scanWholeClasspath() {
            return this.analyzeClasses.wholeClasspath();
        }
    }
}

