/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import java.lang.reflect.Field;
import java.util.Objects;
import org.junit.platform.engine.DiscoverySelector;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class FieldSelector
implements DiscoverySelector {
    private final Class<?> clazz;
    private final Field field;

    private FieldSelector(Class<?> clazz, Field field) {
        this.clazz = clazz;
        this.field = field;
    }

    Class<?> getJavaClass() {
        return this.clazz;
    }

    Field getJavaField() {
        return this.field;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.field);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSelector other = (FieldSelector)obj;
        return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.field, other.field);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{clazz=" + this.clazz + ", field=" + this.field + '}';
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static FieldSelector selectField(String className, String fieldName) {
        return FieldSelector.selectField(FieldSelector.classForName(className), fieldName);
    }

    @MayResolveTypesViaReflection(reason="Within the ArchUnitTestEngine we may resolve types via reflection, since they are needed anyway")
    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load requested class " + className, e);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static FieldSelector selectField(Class<?> javaClass, String fieldName) {
        Field selectedField = FieldSelector.findFieldInHierarchy(javaClass, fieldName);
        if (selectedField == null) {
            throw new IllegalArgumentException(String.format("Could not find field %s.%s", javaClass.getName(), fieldName));
        }
        return FieldSelector.selectField(javaClass, selectedField);
    }

    private static Field findFieldInHierarchy(Class<?> javaClass, String fieldName) {
        Field selectedField = null;
        Class<?> currentClass = javaClass;
        while (selectedField == null && !currentClass.equals(Object.class)) {
            try {
                selectedField = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ignored) {
                currentClass = currentClass.getSuperclass();
            }
        }
        return selectedField;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static FieldSelector selectField(Class<?> javaClass, Field field) {
        return new FieldSelector(javaClass, field);
    }
}

