/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ReflectionUtils;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public class ArchUnitRunner<T>
extends ParentRunner<T> {
    private final InternalRunner<T> runnerDelegate;

    @Internal
    public ArchUnitRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.runnerDelegate = this.createInternalRunner(testClass);
    }

    private InternalRunner<T> createInternalRunner(Class<?> testClass) {
        Class<T> runnerClass = ArchUnitRunner.classForName("com.tngtech.archunit.junit.internal.ArchUnitRunnerInternal");
        return (InternalRunner)ReflectionUtils.newInstanceOf(runnerClass, (Object[])new Object[]{testClass});
    }

    @MayResolveTypesViaReflection(reason="Only used to load internal ArchUnit class")
    private static <T> Class<T> classForName(String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.runnerDelegate.classBlock(notifier);
    }

    protected List<T> getChildren() {
        return this.runnerDelegate.getChildren();
    }

    protected Description describeChild(T child) {
        return this.runnerDelegate.describeChild(child);
    }

    protected void runChild(T child, RunNotifier notifier) {
        this.runnerDelegate.runChild(child, notifier);
    }

    @Internal
    public static interface InternalRunner<T> {
        public Statement classBlock(RunNotifier var1);

        public List<T> getChildren();

        public Description describeChild(T var1);

        public void runChild(T var1, RunNotifier var2);
    }
}

