/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.junit.ArchIgnore;
import com.tngtech.archunit.junit.ArchRules;
import com.tngtech.archunit.junit.ArchTestExecution;
import com.tngtech.archunit.junit.ArchTests;
import com.tngtech.archunit.junit.ReflectionUtils;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

abstract class ArchRuleDeclaration<T extends AnnotatedElement> {
    private final Class<?> testClass;
    final T declaration;
    final Class<?> owner;
    private final boolean forceIgnore;

    ArchRuleDeclaration(Class<?> testClass, T declaration, Class<?> owner, boolean forceIgnore) {
        this.testClass = testClass;
        this.declaration = declaration;
        this.owner = owner;
        this.forceIgnore = forceIgnore;
    }

    abstract void handleWith(Handler var1);

    private static ArchRuleDeclaration<Method> from(Class<?> testClass, Method method, Class<?> methodOwner, boolean forceIgnore) {
        return new AsMethod(testClass, method, methodOwner, forceIgnore);
    }

    private static ArchRuleDeclaration<Field> from(Class<?> testClass, Field field, Class<?> fieldOwner, boolean forceIgnore) {
        return new AsField(testClass, field, fieldOwner, forceIgnore);
    }

    static <T extends AnnotatedElement & Member> boolean elementShouldBeIgnored(T member) {
        return ArchRuleDeclaration.elementShouldBeIgnored(((Member)member).getDeclaringClass(), member);
    }

    static boolean elementShouldBeIgnored(Class<?> testClass, AnnotatedElement ruleDeclaration) {
        return testClass.getAnnotation(ArchIgnore.class) != null || ruleDeclaration.getAnnotation(ArchIgnore.class) != null;
    }

    boolean shouldBeIgnored() {
        return this.forceIgnore || ArchRuleDeclaration.elementShouldBeIgnored(this.testClass, this.declaration);
    }

    static Set<ArchRuleDeclaration<?>> toDeclarations(ArchTests archTests, Class<?> testClass, Class<? extends Annotation> archTestAnnotationType, boolean forceIgnore) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Class<?> definitionLocation = archTests.getDefinitionLocation();
        for (Field field : ReflectionUtils.getAllFields(definitionLocation, ReflectionUtils.withAnnotation(archTestAnnotationType))) {
            result.addAll(ArchRuleDeclaration.archRuleDeclarationsFrom(testClass, field, definitionLocation, archTestAnnotationType, forceIgnore));
        }
        for (Method method : ReflectionUtils.getAllMethods(definitionLocation, ReflectionUtils.withAnnotation(archTestAnnotationType))) {
            result.add(ArchRuleDeclaration.from(testClass, method, definitionLocation, forceIgnore));
        }
        return result.build();
    }

    private static Set<ArchRuleDeclaration<?>> archRuleDeclarationsFrom(Class<?> testClass, Field field, Class<?> fieldOwner, Class<? extends Annotation> archTestAnnotationType, boolean forceIgnore) {
        return ArchTests.class.isAssignableFrom(field.getType()) || ArchRules.class.isAssignableFrom(field.getType()) ? ArchRuleDeclaration.toDeclarations(ArchRuleDeclaration.getArchRulesIn(field, fieldOwner), testClass, archTestAnnotationType, forceIgnore || ArchRuleDeclaration.elementShouldBeIgnored(field)) : Collections.singleton(ArchRuleDeclaration.from(testClass, field, fieldOwner, forceIgnore));
    }

    private static ArchTests getArchRulesIn(Field field, Class<?> fieldOwner) {
        ArchTests value = ArchTests.from(ArchTestExecution.getValue(field, fieldOwner));
        return (ArchTests)Preconditions.checkNotNull((Object)value, (String)"Field %s.%s is not initialized", (Object)fieldOwner.getName(), (Object)field.getName());
    }

    static interface Handler {
        public void handleFieldDeclaration(Field var1, Class<?> var2, boolean var3);

        public void handleMethodDeclaration(Method var1, Class<?> var2, boolean var3);
    }

    private static class AsField
    extends ArchRuleDeclaration<Field> {
        AsField(Class<?> testClass, Field field, Class<?> fieldOwner, boolean forceIgnore) {
            super(testClass, field, fieldOwner, forceIgnore);
        }

        @Override
        void handleWith(Handler handler) {
            handler.handleFieldDeclaration((Field)this.declaration, this.owner, this.shouldBeIgnored());
        }
    }

    private static class AsMethod
    extends ArchRuleDeclaration<Method> {
        AsMethod(Class<?> testClass, Method method, Class<?> methodOwner, boolean forceIgnore) {
            super(testClass, method, methodOwner, forceIgnore);
        }

        @Override
        void handleWith(Handler handler) {
            handler.handleMethodDeclaration((Method)this.declaration, this.owner, this.shouldBeIgnored());
        }
    }
}

