/*
 * Decompiled with CFR 0.152.
 */
package com.timper.view.emptyview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.timper.view.R;

public class EmptyLayout
extends FrameLayout {
    private final Context context;
    private LayoutInflater inflater;
    private OnRefreshListener onRefreshListener;
    private Status status;
    private String emptyInfo;
    private float textSize;
    private int textColor;
    private Drawable res;
    private FrameLayout flRoot;
    private int offHeight = -1;

    public EmptyLayout(Context context) {
        this(context, null);
    }

    @TargetApi(value=21)
    public EmptyLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EmptyLayout);
        this.emptyInfo = typedArray.getString(R.styleable.EmptyLayout_el_info);
        this.textSize = typedArray.getDimension(R.styleable.EmptyLayout_el_textSize, (float)this.dip2px(8.0f));
        this.textColor = typedArray.getColor(R.styleable.EmptyLayout_el_textColor, Color.parseColor((String)"#91959A"));
        this.res = typedArray.hasValue(R.styleable.EmptyLayout_el_res) && typedArray.getDrawable(R.styleable.EmptyLayout_el_res) != null ? typedArray.getDrawable(R.styleable.EmptyLayout_el_res) : context.getDrawable(R.mipmap.icon_empty_nodata);
        typedArray.recycle();
        this.init();
    }

    private void init() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.widget_empty, (ViewGroup)this, false);
        this.flRoot = (FrameLayout)view.findViewById(R.id.fl_root);
        this.addView(view);
        if (this.isNetworkAvailable(this.context)) {
            this.setStatus(Status.NONE);
        } else {
            this.setStatus(Status.NO_NETWORK);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public OnRefreshListener getOnRefreshListener() {
        return this.onRefreshListener;
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.onRefreshListener = onRefreshListener;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        if (!this.isNetworkAvailable(this.context)) {
            this.status = Status.NO_NETWORK;
        }
        this.flRoot.removeAllViews();
        switch (this.status) {
            case NO_NETWORK: {
                View view = this.inflater.inflate(R.layout.widget_empty_nonet, (ViewGroup)this, false);
                view.findViewById(R.id.tv_refresh).setOnClickListener(v -> {
                    if (this.onRefreshListener != null && this.isNetworkAvailable(this.context)) {
                        this.onRefreshListener.onRefresh();
                    }
                });
                this.flRoot.addView(view);
                this.setVisibility(0);
                break;
            }
            case EMPTY: {
                LinearLayout noDataView = (LinearLayout)this.inflater.inflate(R.layout.widget_empty_nodata, null);
                ImageView ivEmpty = (ImageView)noDataView.findViewById(R.id.iv_empty);
                TextView tvEmpty = (TextView)noDataView.findViewById(R.id.tv_no_data);
                tvEmpty.setTextSize(0, this.textSize);
                tvEmpty.setTextColor(this.textColor);
                ivEmpty.setImageDrawable(this.res);
                this.flRoot.addView((View)noDataView);
                if (!TextUtils.isEmpty((CharSequence)this.emptyInfo)) {
                    tvEmpty.setText((CharSequence)this.emptyInfo);
                }
                if (this.offHeight > 0) {
                    ivEmpty.setPadding(0, this.offHeight, 0, 0);
                    noDataView.setGravity(48);
                } else {
                    noDataView.setGravity(17);
                }
                this.setVisibility(0);
                break;
            }
            case REFRESH: {
                this.flRoot.addView(this.inflater.inflate(R.layout.widget_empty_refresh, null));
                this.setVisibility(0);
                break;
            }
            case TRANSPARENT_REFRESH: {
                this.flRoot.addView(this.inflater.inflate(R.layout.widget_empty_refresh_transparent, null));
                this.setVisibility(0);
                break;
            }
            case ERROR: {
                View viewError = this.inflater.inflate(R.layout.widget_empty_error, (ViewGroup)this, false);
                viewError.findViewById(R.id.tv_refresh).setOnClickListener(v -> {
                    if (this.onRefreshListener != null && this.isNetworkAvailable(this.context)) {
                        this.onRefreshListener.onRefresh();
                    }
                });
                this.flRoot.addView(viewError);
                this.setVisibility(0);
                break;
            }
            case NONE: {
                this.setVisibility(8);
                break;
            }
        }
    }

    public void setInfo(String info) {
        this.emptyInfo = info;
    }

    public void setOffHeight(int height) {
        this.offHeight = height;
    }

    public int dip2px(float dpValue) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isNetworkAvailable(Context context) {
        ConnectivityManager mgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo[] info = mgr.getAllNetworkInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }

    public static enum Status {
        NO_NETWORK,
        EMPTY,
        TRANSPARENT_REFRESH,
        REFRESH,
        NONE,
        ERROR;

    }
}

