/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml.processor.xml;

import com.tickaroo.tikxml.annotation.Path;
import com.tickaroo.tikxml.processor.ProcessingException;
import com.tickaroo.tikxml.processor.field.AttributeField;
import com.tickaroo.tikxml.processor.xml.PlaceholderXmlElement;
import com.tickaroo.tikxml.processor.xml.XmlChildElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0016J\u0016\u0010\u0016\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u0018H&J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/tickaroo/tikxml/processor/xml/XmlElement;", "", "attributes", "", "", "Lcom/tickaroo/tikxml/processor/field/AttributeField;", "getAttributes", "()Ljava/util/Map;", "childElements", "Lcom/tickaroo/tikxml/processor/xml/XmlChildElement;", "getChildElements", "element", "Ljavax/lang/model/element/Element;", "getElement", "()Ljavax/lang/model/element/Element;", "addAttribute", "", "attributeField", "path", "", "addChildElement", "toInsert", "getXmlElementForPath", "hasAttributes", "", "hasChildElements", "hasTextContent", "isXmlElementAccessableFromOutsideTypeAdapter", "mergeXmlElements", "parentElement", "toMerge", "into", "processor"})
public interface XmlElement {
    @NotNull
    public Element getElement();

    @NotNull
    public Map<String, AttributeField> getAttributes();

    @NotNull
    public Map<String, XmlChildElement> getChildElements();

    public boolean hasAttributes();

    public boolean hasChildElements();

    public boolean hasTextContent();

    public boolean isXmlElementAccessableFromOutsideTypeAdapter();

    @NotNull
    public XmlElement getXmlElementForPath(@NotNull List<String> var1);

    public void addAttribute(@NotNull AttributeField var1, @NotNull List<String> var2);

    public void addChildElement(@NotNull XmlChildElement var1, @NotNull List<String> var2);

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=3)
    public static final class DefaultImpls {
        public static boolean hasAttributes(XmlElement $this) {
            Map<String, AttributeField> map = $this.getAttributes();
            return !map.isEmpty();
        }

        public static boolean hasChildElements(XmlElement $this) {
            Map<String, XmlChildElement> map = $this.getChildElements();
            return !map.isEmpty();
        }

        public static boolean hasTextContent(XmlElement $this) {
            return false;
        }

        @NotNull
        public static XmlElement getXmlElementForPath(@NotNull XmlElement $this, List<String> path) {
            Intrinsics.checkParameterIsNotNull(path, (String)"path");
            XmlElement currentElement = $this;
            for (String segment : path) {
                XmlChildElement childElement = currentElement.getChildElements().get(segment);
                if (childElement == null) {
                    PlaceholderXmlElement placeholderElement = new PlaceholderXmlElement(segment, currentElement.getElement());
                    Map<String, XmlChildElement> map = currentElement.getChildElements();
                    if (map == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, com.tickaroo.tikxml.processor.xml.XmlChildElement>");
                    }
                    TypeIntrinsics.asMutableMap(map).put(segment, placeholderElement);
                    currentElement = placeholderElement;
                    continue;
                }
                currentElement = childElement;
            }
            return currentElement;
        }

        public static void addAttribute(@NotNull XmlElement $this, @NotNull AttributeField attributeField, List<String> path) {
            Intrinsics.checkParameterIsNotNull((Object)attributeField, (String)"attributeField");
            Intrinsics.checkParameterIsNotNull(path, (String)"path");
            XmlElement currentElement = $this.getXmlElementForPath(path);
            if (!currentElement.isXmlElementAccessableFromOutsideTypeAdapter()) {
                throw (Throwable)new ProcessingException(currentElement.getElement(), "Element " + currentElement + " can't have attributes that are accessed from outside of the TypeAdapter that is generated from @" + Reflection.getOrCreateKotlinClass(com.tickaroo.tikxml.annotation.Element.class).getSimpleName() + " annotated class! Therefore attribute " + attributeField + " can't be added. Most likely the @" + Reflection.getOrCreateKotlinClass(Path.class).getSimpleName() + " is in conflict with an @" + Reflection.getOrCreateKotlinClass(com.tickaroo.tikxml.annotation.Element.class).getSimpleName() + " annotation.");
            }
            AttributeField existingAttribute = currentElement.getAttributes().get(attributeField.getName());
            if (existingAttribute != null) {
                throw (Throwable)new ProcessingException((Element)attributeField.getElement(), "Conflict: " + attributeField + " has the same xml attribute name " + ("'" + attributeField.getName() + "' as the " + existingAttribute + ". ") + "You can specify another name via annotations.");
            }
            Map<String, AttributeField> map = currentElement.getAttributes();
            if (map == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, com.tickaroo.tikxml.processor.field.AttributeField>");
            }
            TypeIntrinsics.asMutableMap(map).put(attributeField.getName(), attributeField);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void addChildElement(@NotNull XmlElement $this, @NotNull XmlChildElement toInsert, List<String> path) {
            Intrinsics.checkParameterIsNotNull((Object)toInsert, (String)"toInsert");
            Intrinsics.checkParameterIsNotNull(path, (String)"path");
            XmlElement currentElement = $this.getXmlElementForPath(path);
            XmlChildElement existingElement = currentElement.getChildElements().get(toInsert.getName());
            if (existingElement != null) {
                if (toInsert.isXmlElementAccessableFromOutsideTypeAdapter() && existingElement.isXmlElementAccessableFromOutsideTypeAdapter() && existingElement instanceof PlaceholderXmlElement) {
                    DefaultImpls.mergeXmlElements($this, currentElement, existingElement, toInsert);
                    return;
                }
                Element variableField = toInsert.getElement();
                throw (Throwable)new ProcessingException(variableField, "Conflict: " + toInsert + " is in conflict with " + existingElement + ". Maybe both have the same xml name '" + toInsert.getName() + "' (you can change that via annotations) or @" + Reflection.getOrCreateKotlinClass(Path.class).getSimpleName() + " is causing this conflict.");
            }
            Map<String, XmlChildElement> map = currentElement.getChildElements();
            if (map == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, com.tickaroo.tikxml.processor.xml.XmlChildElement>");
            }
            TypeIntrinsics.asMutableMap(map).put(toInsert.getName(), toInsert);
        }

        private static void mergeXmlElements(XmlElement $this, XmlElement parentElement, XmlChildElement toMerge, XmlChildElement into) {
            Object name;
            Map.Entry<String, AttributeField> entry;
            Map.Entry<String, Object> entry2;
            Map<String, AttributeField> map = toMerge.getAttributes();
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = entry2 = iterator.next();
                name = entry.getKey();
                entry = entry2;
                AttributeField attributeField = entry.getValue();
                if (into.getAttributes().get(name) != null) {
                    throw (Throwable)new ProcessingException(toMerge.getElement(), "Conflict: " + toMerge + " has the same xml attribute name '" + (String)name + "' as " + into + " . You can specify another name via annotations.");
                }
                Map<String, AttributeField> map2 = into.getAttributes();
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, com.tickaroo.tikxml.processor.field.AttributeField>");
                }
                TypeIntrinsics.asMutableMap(map2).put(name, attributeField);
            }
            name = toMerge.getChildElements();
            iterator = name.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = entry2 = iterator.next();
                name = entry.getKey();
                entry = entry2;
                XmlChildElement element = (XmlChildElement)((Object)entry.getValue());
                if (into.getChildElements().get(name) != null) {
                    throw (Throwable)new ProcessingException(toMerge.getElement(), "Conflict: " + toMerge + " is in conflict with " + into + ". Maybe both have the same xml name '" + (String)name + "' (you can change that via annotations) or @" + Reflection.getOrCreateKotlinClass(Path.class).getSimpleName() + " is causing this conflict.");
                }
                Map<String, XmlChildElement> map3 = into.getChildElements();
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, com.tickaroo.tikxml.processor.xml.XmlChildElement>");
                }
                TypeIntrinsics.asMutableMap(map3).put(name, element);
            }
            Map<String, XmlChildElement> map4 = parentElement.getChildElements();
            if (map4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, com.tickaroo.tikxml.processor.xml.XmlChildElement>");
            }
            TypeIntrinsics.asMutableMap(map4).put(into.getName(), into);
        }
    }
}

