/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml.processor.utils;

import com.tickaroo.tikxml.annotation.Attribute;
import com.tickaroo.tikxml.annotation.PropertyElement;
import com.tickaroo.tikxml.annotation.TextContent;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0007\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u000e\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0010\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0011\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0012\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0013\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0014\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0015\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0016\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0017\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0018\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0019\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u001a\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u001b\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u001c\u001a\u00020\u000b*\u00020\f\u001a\u001a\u0010\u001d\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010 \u001a\u00020\u000b*\u00020\f\u001a\n\u0010!\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\"\u001a\u00020\u000b*\u00020\f\u001a\n\u0010#\u001a\u00020\u000b*\u00020\f\u001a\u001a\u0010$\u001a\u00020\u000b*\u00020\f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'\u001a\n\u0010(\u001a\u00020\u000b*\u00020\f\u001a\n\u0010)\u001a\u00020\u000b*\u00020\f\u00a8\u0006*"}, d2={"getSuperClasses", "", "Ljavax/lang/model/element/TypeElement;", "typeUtils", "Ljavax/lang/model/util/Types;", "getSuperClassesAndAllInterfaces", "getSurroundingClass", "Ljavax/lang/model/element/VariableElement;", "getSurroundingClassQualifiedName", "", "hasEmptyParameters", "", "Ljavax/lang/model/element/Element;", "hasMinimumPackageVisibilityModifiers", "hasSuperClass", "hasTikXmlAnnotation", "isAbstract", "isClass", "isConstructor", "isDefaultVisibility", "isEmptyConstructor", "isEmptyConstructorWithMinimumPackageVisibility", "isField", "isFinal", "isGetterMethodWithMinimumPackageVisibility", "isInterface", "isList", "isMethod", "isMethodWithMinimumPackageVisibility", "isMethodWithOneParameterOfType", "type", "Ljavax/lang/model/type/TypeMirror;", "isParameterlessMethod", "isPrivate", "isProtected", "isPublic", "isSamePackageAs", "other", "utils", "Ljavax/lang/model/util/Elements;", "isSetterMethodWithMinimumPackageVisibility", "isStatic", "processor-common"})
public final class ElementExtensionsKt {
    public static final boolean hasMinimumPackageVisibilityModifiers(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return !ElementExtensionsKt.isProtected($receiver) && !ElementExtensionsKt.isPrivate($receiver);
    }

    public static final boolean isSamePackageAs(@NotNull Element $receiver, @NotNull Element other, @NotNull Elements utils) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)utils, (String)"utils");
        return Intrinsics.areEqual((Object)utils.getPackageOf($receiver), (Object)utils.getPackageOf(other));
    }

    public static final boolean isPrivate(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public static final boolean isProtected(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    public static final boolean isPublic(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public static final boolean isDefaultVisibility(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return !ElementExtensionsKt.isPrivate($receiver) && !ElementExtensionsKt.isProtected($receiver) && !ElementExtensionsKt.isPublic($receiver);
    }

    public static final boolean isAbstract(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public static final boolean isInterface(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getKind()), (Object)((Object)ElementKind.INTERFACE));
    }

    public static final boolean isStatic(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static final boolean isFinal(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static final boolean isField(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getKind()), (Object)((Object)ElementKind.FIELD));
    }

    public static final boolean isClass(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getKind()), (Object)((Object)ElementKind.CLASS));
    }

    public static final boolean isMethod(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getKind()), (Object)((Object)ElementKind.METHOD));
    }

    public static final boolean isConstructor(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getKind()), (Object)((Object)ElementKind.CONSTRUCTOR));
    }

    public static final boolean hasEmptyParameters(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Element element = $receiver;
        if (element == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
        }
        return ((ExecutableElement)element).getParameters().isEmpty();
    }

    public static final boolean isEmptyConstructor(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElementExtensionsKt.isConstructor($receiver) && ElementExtensionsKt.hasEmptyParameters($receiver);
    }

    public static final boolean isEmptyConstructorWithMinimumPackageVisibility(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElementExtensionsKt.isEmptyConstructor($receiver) && ElementExtensionsKt.hasMinimumPackageVisibilityModifiers($receiver);
    }

    public static final boolean isMethodWithMinimumPackageVisibility(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElementExtensionsKt.isMethod($receiver) && ElementExtensionsKt.hasMinimumPackageVisibilityModifiers($receiver);
    }

    public static final boolean isGetterMethodWithMinimumPackageVisibility(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElementExtensionsKt.isMethodWithMinimumPackageVisibility($receiver) && (StringsKt.startsWith$default((CharSequence)$receiver.getSimpleName(), (CharSequence)"get", (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)$receiver.getSimpleName(), (CharSequence)"is", (boolean)false, (int)2, null));
    }

    public static final boolean isSetterMethodWithMinimumPackageVisibility(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElementExtensionsKt.isMethodWithMinimumPackageVisibility($receiver) && StringsKt.startsWith$default((CharSequence)$receiver.getSimpleName(), (CharSequence)"set", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isMethodWithOneParameterOfType(@NotNull Element $receiver, @NotNull TypeMirror type, @NotNull Types typeUtils) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)typeUtils, (String)"typeUtils");
        if (!ElementExtensionsKt.isMethod($receiver)) return false;
        Element element = $receiver;
        if (element == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
        }
        if (((ExecutableElement)element).getParameters().size() != 1) return false;
        if (!typeUtils.isAssignable(((ExecutableElement)$receiver).getParameters().get(0).asType(), type)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isParameterlessMethod(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!ElementExtensionsKt.isMethod($receiver)) return false;
        Element element = $receiver;
        if (element == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
        }
        if (!((ExecutableElement)element).getParameters().isEmpty()) return false;
        return true;
    }

    @NotNull
    public static final TypeElement getSurroundingClass(@NotNull VariableElement $receiver) {
        TypeElement typeElement;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Element element = $receiver.getEnclosingElement();
        if (element instanceof TypeElement) {
            Element element2 = $receiver.getEnclosingElement();
            if (element2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            typeElement = (TypeElement)element2;
        } else if (element instanceof ExecutableElement) {
            Element element3 = $receiver.getEnclosingElement().getEnclosingElement();
            if (element3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            typeElement = (TypeElement)element3;
        } else {
            throw (Throwable)new IllegalArgumentException("Unexpected enclosing element " + $receiver.getEnclosingElement() + " for " + $receiver);
        }
        return typeElement;
    }

    @NotNull
    public static final String getSurroundingClassQualifiedName(@NotNull VariableElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElementExtensionsKt.getSurroundingClass($receiver).getQualifiedName().toString();
    }

    public static final boolean hasSuperClass(@NotNull TypeElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)((Object)$receiver.getSuperclass().getKind()), (Object)((Object)TypeKind.NONE)) ^ true;
    }

    @NotNull
    public static final List<TypeElement> getSuperClasses(@NotNull TypeElement $receiver, @NotNull Types typeUtils) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)typeUtils, (String)"typeUtils");
        ArrayList<TypeElement> superClasses = new ArrayList<TypeElement>();
        TypeElement current = $receiver;
        while (ElementExtensionsKt.hasSuperClass(current)) {
            Element element = typeUtils.asElement(current.getSuperclass());
            if (element == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            current = (TypeElement)element;
            superClasses.add(current);
        }
        return superClasses;
    }

    @NotNull
    public static final List<TypeElement> getSuperClassesAndAllInterfaces(@NotNull TypeElement $receiver, @NotNull Types typeUtils) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)typeUtils, (String)"typeUtils");
        ArrayList<TypeElement> superClasses = new ArrayList<TypeElement>();
        TypeElement current = $receiver;
        Function1<TypeElement, Unit> addInterfaces$ = new Function1<TypeElement, Unit>(superClasses, typeUtils){
            final /* synthetic */ ArrayList $superClasses;
            final /* synthetic */ Types $typeUtils;

            public final void invoke(@NotNull TypeElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element.getInterfaces() != null && !element.getInterfaces().isEmpty()) {
                    Iterable $receiver$iv = element.getInterfaces();
                    for (T element$iv : $receiver$iv) {
                        TypeMirror it = (TypeMirror)element$iv;
                        Element element2 = this.$typeUtils.asElement(it);
                        if (element2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                        }
                        this.$superClasses.add((TypeElement)element2);
                    }
                }
            }
            {
                this.$superClasses = arrayList;
                this.$typeUtils = types;
                super(1);
            }
        };
        addInterfaces$.invoke(current);
        while (ElementExtensionsKt.hasSuperClass(current)) {
            Element element = typeUtils.asElement(current.getSuperclass());
            if (element == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            current = (TypeElement)element;
            superClasses.add(current);
            addInterfaces$.invoke(current);
        }
        return superClasses;
    }

    public static final boolean hasTikXmlAnnotation(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotation(Attribute.class) != null || $receiver.getAnnotation(PropertyElement.class) != null || $receiver.getAnnotation(com.tickaroo.tikxml.annotation.Element.class) != null || $receiver.getAnnotation(TextContent.class) != null;
    }

    public static final boolean isList(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.startsWith$default((String)((Object)$receiver.asType()).toString(), (String)"java.util.List", (boolean)false, (int)2, null);
    }
}

