/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.jenkins.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.thycotic.jenkins.credentials.ThycoticVaultCredentials;
import com.thycotic.vault.client.BaseClient;
import com.thycotic.vault.client.IDevOpsSecretsVaultClient;
import hudson.Extension;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class ClientCredentials
extends BaseStandardCredentials
implements ThycoticVaultCredentials {
    @Nonnull
    private final Secret clientSecret;
    @Nonnull
    private final String clientId;
    @Nonnull
    private final String tenant;
    @Nonnull
    private final String baseURL;

    @DataBoundConstructor
    public ClientCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @Nonnull String tenant, @Nonnull String clientId, @Nonnull Secret clientSecret, @Nonnull String baseURL) {
        super(scope, id, description);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tenant = tenant;
        this.baseURL = baseURL;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public IDevOpsSecretsVaultClient getVaultClient() {
        return new BaseClient(this.tenant, this.clientId, this.clientSecret.getPlainText(), this.baseURL);
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Thycotic DevOps Vault Client Credentials";
        }
    }
}

