/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.thycotic.jenkins.configuration.DevOpsSecretsVaultConfigResolver;
import com.thycotic.jenkins.configuration.DevOpsSecretsVaultConfiguration;
import com.thycotic.jenkins.credentials.ThycoticVaultCredentials;
import com.thycotic.jenkins.model.ThycoticSecret;
import com.thycotic.jenkins.model.ThycoticSecretValue;
import com.thycotic.vault.exceptions.DevOpsSecretsVaultException;
import com.thycotic.vault.secret.BaseSecretService;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.tasks.SimpleBuildWrapper;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ThycoticVaultBuildWrapper
extends SimpleBuildWrapper {
    private List<ThycoticSecret> thycoticVaultSecrets;
    private DevOpsSecretsVaultConfiguration configuration;

    @DataBoundConstructor
    public ThycoticVaultBuildWrapper(@CheckForNull List<ThycoticSecret> thycoticVaultSecrets) {
        this.thycoticVaultSecrets = thycoticVaultSecrets;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath filePath, Launcher launcher, TaskListener taskListener, EnvVars envVars) throws IOException, InterruptedException {
        PrintStream logger = taskListener.getLogger();
        this.updateConfig(build);
        ThycoticVaultCredentials credential = this.getCredentials(build);
        if (this.thycoticVaultSecrets != null && !this.thycoticVaultSecrets.isEmpty()) {
            try {
                this.populateSecrets(context, credential);
            }
            catch (Exception e) {
                e.printStackTrace(logger);
                throw new AbortException(e.getMessage());
            }
        }
    }

    public List<ThycoticSecret> getThycoticVaultSecrets() {
        return this.thycoticVaultSecrets;
    }

    @DataBoundSetter
    public void setConfiguration(DevOpsSecretsVaultConfiguration configuration) {
        this.configuration = configuration;
    }

    public DevOpsSecretsVaultConfiguration getConfiguration() {
        return this.configuration;
    }

    private ThycoticVaultCredentials getCredentials(Run build) {
        String id = this.getConfiguration().getThycoticCredentialId();
        if (StringUtils.isBlank((String)id)) {
            throw new RuntimeException("The credential id was not configured - please specify the credentials to use.");
        }
        List credentials = CredentialsProvider.lookupCredentials(ThycoticVaultCredentials.class, (Item)build.getParent(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        ThycoticVaultCredentials credential = (ThycoticVaultCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)new IdMatcher(id));
        if (credential == null) {
            throw new RuntimeException("No credential exists that matches the configured credential id.");
        }
        return credential;
    }

    private void populateSecrets(SimpleBuildWrapper.Context context, ThycoticVaultCredentials credentials) {
        BaseSecretService secretService = new BaseSecretService(credentials.getVaultClient());
        try {
            for (ThycoticSecret secret : this.thycoticVaultSecrets) {
                Map secretMap = secretService.getSecretMap(secret.getPath());
                for (ThycoticSecretValue secretValue : secret.getSecretValues()) {
                    String env = secretValue.getEnvVar();
                    String value = (String)secretMap.get(secretValue.getKey());
                    context.env(env, value);
                }
            }
        }
        catch (DevOpsSecretsVaultException e) {
            throw new RuntimeException("Exception calling DevOps Secrets Vault API", e);
        }
    }

    private void updateConfig(Run<?, ?> build) {
        for (DevOpsSecretsVaultConfigResolver resolver : ExtensionList.lookup(DevOpsSecretsVaultConfigResolver.class)) {
            if (this.configuration != null) {
                this.configuration = this.configuration.mergeWithParent(resolver.forJob((Item)build.getParent()));
                continue;
            }
            this.configuration = resolver.forJob((Item)build.getParent());
        }
        if (this.configuration == null) {
            throw new RuntimeException("No configuration found - please configure the DevOps Secrets Vault Plugin.");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(ThycoticVaultBuildWrapper.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Thycotic DevOps Secrets Vault Plugin";
        }
    }
}

