/*
 * Decompiled with CFR 0.152.
 */
package com.thirtydegreesray.dataautoaccess;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class DataAutoAccess {
    private static final String SUFFIX = "$$DataAccessor";
    private static LinkedHashMap<String, DataAccessor<Object>> dataAccessorMap = new LinkedHashMap();

    public static void getData(Object targetObject, Bundle dataStore) {
        if (targetObject == null) {
            return;
        }
        if (targetObject instanceof Activity && dataStore == null) {
            dataStore = ((Activity)targetObject).getIntent().getExtras();
        }
        if (dataStore == null) {
            return;
        }
        List<DataAccessor<Object>> dataAccessors = DataAutoAccess.getDataAccessors(targetObject);
        for (DataAccessor<Object> dataAccessor : dataAccessors) {
            dataAccessor.getData(targetObject, dataStore);
        }
    }

    public static void saveData(Object targetObject, Bundle dataStore) {
        if (targetObject == null || dataStore == null) {
            return;
        }
        List<DataAccessor<Object>> dataAccessors = DataAutoAccess.getDataAccessors(targetObject);
        for (DataAccessor<Object> dataAccessor : dataAccessors) {
            dataAccessor.saveData(targetObject, dataStore);
        }
    }

    private static List<DataAccessor<Object>> getDataAccessors(Object targetObject) {
        ArrayList<DataAccessor<Object>> dataAccessors = new ArrayList<DataAccessor<Object>>();
        Class<?> targetClass = targetObject.getClass();
        DataAutoAccess.getDataAccessors(dataAccessors, targetClass);
        return dataAccessors;
    }

    private static List<DataAccessor<Object>> getDataAccessors(List<DataAccessor<Object>> dataAccessors, Class<?> targetClass) {
        String className = targetClass.getName() + SUFFIX;
        DataAccessor<Object> dataAccessor = DataAutoAccess.getDataAccessor(className);
        if (dataAccessor != null) {
            dataAccessors.add(dataAccessor);
        }
        if (targetClass.getSuperclass() != null) {
            DataAutoAccess.getDataAccessors(dataAccessors, targetClass.getSuperclass());
        }
        return dataAccessors;
    }

    private static DataAccessor<Object> getDataAccessor(String className) {
        if (!dataAccessorMap.containsKey(className)) {
            try {
                Class<?> dataAccessorClass = Class.forName(className);
                DataAccessor dataAccessor = (DataAccessor)dataAccessorClass.newInstance();
                dataAccessorMap.put(className, dataAccessor);
            }
            catch (ClassNotFoundException dataAccessorClass) {
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return dataAccessorMap.get(className);
    }

    public static <T> T getCastData(String key, Bundle dataStore) {
        return (T)dataStore.get(key);
    }

    public static void saveArrayList(String key, ArrayList list, Bundle dataStore) {
        if (list == null) {
            return;
        }
        Object[] listArray = list.toArray();
        if (listArray instanceof String[]) {
            dataStore.putStringArrayList(key, list);
        } else if (listArray instanceof Integer[]) {
            dataStore.putIntegerArrayList(key, list);
        } else if (listArray instanceof Parcelable[]) {
            dataStore.putParcelableArrayList(key, list);
        } else if (listArray instanceof CharSequence[]) {
            if (Build.VERSION.SDK_INT >= 8) {
                dataStore.putCharSequenceArrayList(key, list);
            }
        } else {
            throw new NullPointerException("");
        }
    }

    public static interface DataAccessor<T> {
        public void getData(T var1, Bundle var2);

        public void saveData(T var1, Bundle var2);
    }
}

