/*
 * Decompiled with CFR 0.152.
 */
package com.thirtydegreesray.dataautoaccess;

import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class DataAutoAccess {
    private static final String SUFFIX = "$$DataAccessor";
    private static LinkedHashMap<String, DataAccessor<Object>> dataAccessorMap = new LinkedHashMap();

    public static void getData(Object targetObject, Bundle dataStore) {
        if (targetObject == null || dataStore == null) {
            return;
        }
        DataAccessor<Object> dataAccessor = DataAutoAccess.getDataAccessor(targetObject, dataStore);
        if (dataAccessor != null) {
            dataAccessor.getData(targetObject, dataStore);
        }
    }

    public static void saveData(Object targetObject, Bundle dataStore) {
        if (targetObject == null || dataStore == null) {
            return;
        }
        DataAccessor<Object> dataAccessor = DataAutoAccess.getDataAccessor(targetObject, dataStore);
        if (dataAccessor != null) {
            dataAccessor.saveData(targetObject, dataStore);
        }
    }

    private static DataAccessor<Object> getDataAccessor(Object targetObject, Bundle dataStore) {
        Class<?> targetClass = targetObject.getClass();
        String className = targetClass.getName() + SUFFIX;
        return DataAutoAccess.getDataAccessor(className);
    }

    private static DataAccessor<Object> getDataAccessor(String className) {
        if (!dataAccessorMap.containsKey(className)) {
            try {
                Class<?> dataAccessorClass = Class.forName(className);
                DataAccessor dataAccessor = (DataAccessor)dataAccessorClass.newInstance();
                dataAccessorMap.put(className, dataAccessor);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return dataAccessorMap.get(className);
    }

    public static <T> T getCastData(String key, Bundle dataStore) {
        return (T)dataStore.get(key);
    }

    public static void saveArrayList(String key, ArrayList list, Bundle dataStore) {
        if (list == null) {
            return;
        }
        Object[] listArray = list.toArray();
        if (listArray instanceof String[]) {
            dataStore.putStringArrayList(key, list);
        } else if (listArray instanceof Integer[]) {
            dataStore.putIntegerArrayList(key, list);
        } else if (listArray instanceof Parcelable[]) {
            dataStore.putParcelableArrayList(key, list);
        } else if (listArray instanceof CharSequence[] && Build.VERSION.SDK_INT >= 8) {
            dataStore.putCharSequenceArrayList(key, list);
        }
    }

    public static interface DataAccessor<T> {
        public void getData(T var1, Bundle var2);

        public void saveData(T var1, Bundle var2);
    }
}

