/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import com.theoryinpractise.clojure.NamespaceDiscovery;
import com.theoryinpractise.clojure.NamespaceInFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="test-with-junit", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class ClojureRunTestWithJUnitMojo
extends AbstractClojureCompilerMojo {
    @Parameter(required=true, property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(required=true, property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter
    private String testScript;
    @Parameter(defaultValue="${project.build.directory}/test-reports", property="clojure.testOutputDirectory")
    private String testOutputDirectory;
    @Parameter(defaultValue="true", property="clojure.xmlEscapeOutput")
    private boolean xmlEscapeOutput;
    @Parameter(property="test")
    private String test;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipTests) {
            this.getLog().info((CharSequence)"Test execution is skipped");
        } else {
            try {
                File[] testSourceDirectories = this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST);
                File[] allSourceDirectories = this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST, AbstractClojureCompilerMojo.SourceDirectory.COMPILE);
                File outputFile = new File(this.testOutputDirectory);
                NamespaceInFile[] ns = new NamespaceDiscovery(this.getLog(), outputFile, this.charset, this.testDeclaredNamespaceOnly).discoverNamespacesIn(this.testNamespaces, testSourceDirectories);
                if (this.test != null) {
                    ArrayList<NamespaceInFile> filteredNS = new ArrayList<NamespaceInFile>();
                    String[] patterns = this.test.split("\\s*,\\s*");
                    block2: for (NamespaceInFile nsinf : ns) {
                        for (String pattern : patterns) {
                            if (!nsinf.getName().contains(pattern)) continue;
                            filteredNS.add(nsinf);
                            continue block2;
                        }
                    }
                    ns = filteredNS.toArray(new NamespaceInFile[filteredNS.size()]);
                }
                File confFile = File.createTempFile("run-test", ".txt");
                confFile.deleteOnExit();
                PrintWriter confWriter = new PrintWriter(new FileWriter(confFile));
                this.generateConfig(confWriter, ns);
                confWriter.close();
                String testConf = confFile.getPath();
                if (!this.isClasspathResource(this.testScript)) {
                    if (!this.isExistingTestScriptFile(this.testScript)) {
                        outputFile.mkdir();
                        File testFile = File.createTempFile("run-test", ".clj");
                        testFile.deleteOnExit();
                        PrintWriter writer = new PrintWriter(new FileWriter(testFile));
                        this.generateTestScript(writer);
                        writer.close();
                        this.testScript = testFile.getPath();
                    } else {
                        File testFile = new File(this.testScript);
                        if (!testFile.exists()) {
                            testFile = new File(this.getWorkingDirectory(), this.testScript);
                        }
                        if (!testFile.exists()) {
                            throw new MojoExecutionException("testScript " + testFile.getPath() + " does not exist.");
                        }
                    }
                }
                this.getLog().debug((CharSequence)("Running clojure:test-with-junit against " + this.testScript));
                this.callClojureWith(allSourceDirectories, this.outputDirectory, (List<String>)this.testClasspathElements, "clojure.main", new String[]{this.testScript, testConf});
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    protected void generateConfig(PrintWriter writer, NamespaceInFile[] ns) throws IOException {
        Properties props = this.getProps(ns);
        props.store(writer, "Test Run Properties");
    }

    protected Properties getProps(NamespaceInFile[] ns) {
        Properties props = new Properties();
        for (int i = 0; i < ns.length; ++i) {
            props.put("ns." + i, ns[i].getName());
        }
        props.put("junit", "True");
        props.put("outputDir", this.testOutputDirectory);
        props.put("xmlEscape", String.valueOf(this.xmlEscapeOutput));
        return props;
    }

    private void generateTestScript(PrintWriter writer) throws IOException {
        IOUtils.copy((InputStream)ClojureRunTestWithJUnitMojo.class.getResourceAsStream("/default_test_script.clj"), (Writer)writer);
    }
}

