/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.theokanning.openai.AuthenticationInterceptor;
import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.OpenAiApi;
import com.theokanning.openai.OpenAiResponse;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.edit.EditRequest;
import com.theokanning.openai.edit.EditResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.engine.Engine;
import com.theokanning.openai.file.File;
import com.theokanning.openai.finetune.FineTuneEvent;
import com.theokanning.openai.finetune.FineTuneRequest;
import com.theokanning.openai.finetune.FineTuneResult;
import com.theokanning.openai.image.CreateImageEditRequest;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.CreateImageVariationRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.model.Model;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiService {
    private static final String BASE_URL = "https://api.openai.com/";
    final OpenAiApi api;

    public OpenAiService(String token) {
        this(token, BASE_URL, Duration.ofSeconds(10L));
    }

    @Deprecated
    public OpenAiService(String token, int timeout) {
        this(token, BASE_URL, Duration.ofSeconds(timeout));
    }

    public OpenAiService(String token, Duration timeout) {
        this(token, BASE_URL, timeout);
    }

    public OpenAiService(String token, String baseUrl, Duration timeout) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(token)).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
        this.api = (OpenAiApi)retrofit.create(OpenAiApi.class);
    }

    public OpenAiService(OpenAiApi api) {
        this.api = api;
    }

    public List<Model> listModels() {
        return ((OpenAiResponse)this.api.listModels().blockingGet()).data;
    }

    public Model getModel(String modelId) {
        return (Model)this.api.getModel(modelId).blockingGet();
    }

    public CompletionResult createCompletion(CompletionRequest request) {
        return (CompletionResult)this.api.createCompletion(request).blockingGet();
    }

    @Deprecated
    public CompletionResult createCompletion(String engineId, CompletionRequest request) {
        return (CompletionResult)this.api.createCompletion(engineId, request).blockingGet();
    }

    public EditResult createEdit(EditRequest request) {
        return (EditResult)this.api.createEdit(request).blockingGet();
    }

    @Deprecated
    public EditResult createEdit(String engineId, EditRequest request) {
        return (EditResult)this.api.createEdit(engineId, request).blockingGet();
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        return (EmbeddingResult)this.api.createEmbeddings(request).blockingGet();
    }

    @Deprecated
    public EmbeddingResult createEmbeddings(String engineId, EmbeddingRequest request) {
        return (EmbeddingResult)this.api.createEmbeddings(engineId, request).blockingGet();
    }

    public List<File> listFiles() {
        return ((OpenAiResponse)this.api.listFiles().blockingGet()).data;
    }

    public File uploadFile(String purpose, String filepath) {
        java.io.File file = new java.io.File(filepath);
        RequestBody purposeBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)purpose);
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"text"), (java.io.File)file);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)filepath, (RequestBody)fileBody);
        return (File)this.api.uploadFile(purposeBody, body).blockingGet();
    }

    public DeleteResult deleteFile(String fileId) {
        return (DeleteResult)this.api.deleteFile(fileId).blockingGet();
    }

    public File retrieveFile(String fileId) {
        return (File)this.api.retrieveFile(fileId).blockingGet();
    }

    public FineTuneResult createFineTune(FineTuneRequest request) {
        return (FineTuneResult)this.api.createFineTune(request).blockingGet();
    }

    public CompletionResult createFineTuneCompletion(CompletionRequest request) {
        return (CompletionResult)this.api.createFineTuneCompletion(request).blockingGet();
    }

    public List<FineTuneResult> listFineTunes() {
        return ((OpenAiResponse)this.api.listFineTunes().blockingGet()).data;
    }

    public FineTuneResult retrieveFineTune(String fineTuneId) {
        return (FineTuneResult)this.api.retrieveFineTune(fineTuneId).blockingGet();
    }

    public FineTuneResult cancelFineTune(String fineTuneId) {
        return (FineTuneResult)this.api.cancelFineTune(fineTuneId).blockingGet();
    }

    public List<FineTuneEvent> listFineTuneEvents(String fineTuneId) {
        return ((OpenAiResponse)this.api.listFineTuneEvents((String)fineTuneId).blockingGet()).data;
    }

    public DeleteResult deleteFineTune(String fineTuneId) {
        return (DeleteResult)this.api.deleteFineTune(fineTuneId).blockingGet();
    }

    public ImageResult createImage(CreateImageRequest request) {
        return (ImageResult)this.api.createImage(request).blockingGet();
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, String imagePath, String maskPath) {
        java.io.File image = new java.io.File(imagePath);
        java.io.File mask = null;
        if (maskPath != null) {
            mask = new java.io.File(maskPath);
        }
        return this.createImageEdit(request, image, mask);
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, java.io.File image, java.io.File mask) {
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)image);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("prompt", request.getPrompt()).addFormDataPart("size", request.getSize()).addFormDataPart("response_format", request.getResponseFormat()).addFormDataPart("image", "image", imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        if (mask != null) {
            RequestBody maskBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)mask);
            builder.addFormDataPart("mask", "mask", maskBody);
        }
        return (ImageResult)this.api.createImageEdit((RequestBody)builder.build()).blockingGet();
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, String imagePath) {
        java.io.File image = new java.io.File(imagePath);
        return this.createImageVariation(request, image);
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, java.io.File image) {
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)image);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("size", request.getSize()).addFormDataPart("response_format", request.getResponseFormat()).addFormDataPart("image", "image", imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        return (ImageResult)this.api.createImageVariation((RequestBody)builder.build()).blockingGet();
    }

    public ModerationResult createModeration(ModerationRequest request) {
        return (ModerationResult)this.api.createModeration(request).blockingGet();
    }

    @Deprecated
    public List<Engine> getEngines() {
        return ((OpenAiResponse)this.api.getEngines().blockingGet()).data;
    }

    @Deprecated
    public Engine getEngine(String engineId) {
        return (Engine)this.api.getEngine(engineId).blockingGet();
    }
}

