/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.buffer;

import com.thelastcheck.commons.buffer.ByteArray;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.LoggerFactory;

public class ByteArrayReader
extends Reader {
    private static final String CVS_ID = "$Date: 2010/11/15 17:42:05 $ $Revision: 1.4 $";
    private ByteArray buffer;
    private int limit;
    private int position;
    private int mark;

    public ByteArrayReader(ByteArray buffer) {
        this.buffer = buffer;
        this.position = 0;
        this.limit = buffer.getLength();
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
    }

    public int getTotalBytesRead() {
        return this.position;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.position >= this.limit) {
            return -1;
        }
        int bytesRead = this.buffer.read(this.position, cbuf, off, len);
        this.position += bytesRead;
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.position >= this.limit) {
            return -1;
        }
        return this.buffer.readAsChar(this.position++);
    }

    private void ensureOpen() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    @Override
    public long skip(long ns) throws IOException {
        this.ensureOpen();
        if (this.position >= this.limit) {
            return 0L;
        }
        long n = Math.min((long)(this.limit - this.position), ns);
        n = Math.max((long)(-this.position), n);
        this.position = (int)((long)this.position + n);
        return n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.ensureOpen();
        this.mark = this.position;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        this.position = this.mark;
    }

    static {
        String className = ByteArrayReader.class.getName();
        LoggerFactory.getLogger((String)"version").info(className + " | " + CVS_ID);
    }
}

