/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.buffer;

import com.thelastcheck.commons.buffer.ByteArray;
import java.io.UnsupportedEncodingException;

public abstract class ByteArrayConverter {
    private byte[] convertToTable;

    protected ByteArrayConverter() {
        try {
            this.convertToTable = this.loadConvertTable();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected abstract byte[] loadConvertTable() throws UnsupportedEncodingException;

    protected abstract String outputEncoding();

    public byte[] convert(byte[] bytes) {
        return this.convert(bytes, 0, bytes.length);
    }

    public byte[] convert(byte[] bytes, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] bytesConverted = new byte[length];
        int i = offset;
        for (int j = 0; j < length; ++j) {
            bytesConverted[j] = this.convert(bytes[i]);
            ++i;
        }
        return bytesConverted;
    }

    public byte convert(byte b) {
        int i = b & 0xFF;
        return this.convertToTable[i];
    }

    public byte[] convert(char[] chars) {
        return this.convert(chars, 0, chars.length);
    }

    public byte[] convert(char[] chars, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > chars.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] bytesConverted = new byte[length];
        int i = offset;
        for (int j = 0; j < length; ++j) {
            bytesConverted[j] = this.convert(chars[i]);
            ++i;
        }
        return bytesConverted;
    }

    public byte convert(char c) {
        int i = (byte)c & 0xFF;
        return this.convertToTable[i];
    }

    public ByteArray convert(ByteArray byteArray) {
        return this.convert(byteArray, 0, byteArray.getLength());
    }

    public ByteArray convert(ByteArray byteArray, int offset, int length) {
        byte[] bytesConverted;
        if (byteArray.hasArray()) {
            ByteArray.UnderlyingArray array = byteArray.getArray();
            bytesConverted = this.convert(array.value, offset + array.offset, length);
        } else {
            bytesConverted = this.convert(byteArray.getBytes(), offset, length);
        }
        return new ByteArray(bytesConverted, this.outputEncoding());
    }
}

