/*
 * Decompiled with CFR 0.152.
 */
package com.theapache64.twinkill.network.utils.retrofit.interceptors;

import android.util.Log;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/theapache64/twinkill/network/utils/retrofit/interceptors/CurlInterceptor;", "Lokhttp3/Interceptor;", "()V", "tag", "", "(Ljava/lang/String;)V", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "curlCommandBuilder", "Ljava/lang/StringBuffer;", "addHeader", "", "headerName", "headerValue", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "CurlPrinter", "network_release"})
public final class CurlInterceptor
implements Interceptor {
    private StringBuffer curlCommandBuilder;
    private final Charset UTF8;
    private String tag;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        StringBuffer stringBuffer = this.curlCommandBuilder = new StringBuffer("");
        if (stringBuffer == null) {
            Intrinsics.throwNpe();
        }
        stringBuffer.append("curl ");
        StringBuffer stringBuffer2 = this.curlCommandBuilder;
        if (stringBuffer2 == null) {
            Intrinsics.throwNpe();
        }
        stringBuffer2.append("-X ");
        StringBuffer stringBuffer3 = this.curlCommandBuilder;
        if (stringBuffer3 == null) {
            Intrinsics.throwNpe();
        }
        String string = request.method();
        StringBuffer stringBuffer4 = stringBuffer3;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        String string4 = string3;
        stringBuffer4.append(string4).append(" ");
        for (String headerName : request.headers().names()) {
            this.addHeader(headerName, request.headers().get(headerName));
        }
        RequestBody requestBody = request.body();
        if (request.body() != null) {
            Buffer buffer = new Buffer();
            boolean bl2 = requestBody != null;
            boolean bl3 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl5 = false;
                String string5 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string5));
            }
            RequestBody requestBody2 = requestBody;
            if (requestBody2 == null) {
                Intrinsics.throwNpe();
            }
            requestBody2.writeTo((BufferedSink)buffer);
            Charset charset = null;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                RequestBody requestBody3 = request.body();
                if (requestBody3 == null) {
                    Intrinsics.throwNpe();
                }
                MediaType mediaType = requestBody3.contentType();
                if (mediaType == null) {
                    Intrinsics.throwNpe();
                }
                this.addHeader("Content-Type", mediaType.toString());
                charset = contentType.charset(this.UTF8);
                bl4 = charset != null;
                boolean bl6 = false;
                boolean bl7 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl8 = false;
                    String string6 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string6));
                }
                StringBuffer stringBuffer5 = this.curlCommandBuilder;
                if (stringBuffer5 == null) {
                    Intrinsics.throwNpe();
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(" -d '");
                Charset charset2 = charset;
                if (charset2 == null) {
                    Intrinsics.throwNpe();
                }
                stringBuffer6.append(buffer.readString(charset2)).append("'");
            }
        }
        StringBuffer stringBuffer7 = this.curlCommandBuilder;
        if (stringBuffer7 == null) {
            Intrinsics.throwNpe();
        }
        stringBuffer7.append(" \"").append(request.url().toString()).append("\"");
        StringBuffer stringBuffer8 = this.curlCommandBuilder;
        if (stringBuffer8 == null) {
            Intrinsics.throwNpe();
        }
        stringBuffer8.append(" -L | jq '.'");
        String string7 = request.url().toString();
        StringBuffer stringBuffer9 = this.curlCommandBuilder;
        if (stringBuffer9 == null) {
            Intrinsics.throwNpe();
        }
        String string8 = stringBuffer9.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"curlCommandBuilder!!.toString()");
        CurlPrinter.INSTANCE.print$network_release(this.tag, string7, string8);
        return chain.proceed(request);
    }

    private final void addHeader(String headerName, String headerValue) {
        StringBuffer stringBuffer = this.curlCommandBuilder;
        if (stringBuffer == null) {
            Intrinsics.throwNpe();
        }
        stringBuffer.append("-H \"").append(headerName).append(": ").append(headerValue).append("\" ");
    }

    public CurlInterceptor() {
        this.UTF8 = Charset.forName("UTF-8");
    }

    public CurlInterceptor(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.UTF8 = Charset.forName("UTF-8");
        this.tag = tag;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002J'\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/theapache64/twinkill/network/utils/retrofit/interceptors/CurlInterceptor$CurlPrinter;", "", "()V", "SINGLE_DIVIDER", "", "sTag", "log", "", "msg", "print", "tag", "url", "print$network_release", "network_release"})
    public static final class CurlPrinter {
        private static final String SINGLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
        private static String sTag;
        public static final CurlPrinter INSTANCE;

        public final void print$network_release(@Nullable String tag, @NotNull String url, @NotNull String msg) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            if (tag != null) {
                sTag = tag;
            }
            String logMsg = "\n\nURL: " + url + "\n" + SINGLE_DIVIDER + "\n" + msg + " " + " \n" + SINGLE_DIVIDER + " \n ";
            this.log(logMsg);
        }

        private final void log(String msg) {
            Log.d((String)sTag, (String)msg);
        }

        private CurlPrinter() {
        }

        static {
            CurlPrinter curlPrinter;
            INSTANCE = curlPrinter = new CurlPrinter();
            SINGLE_DIVIDER = SINGLE_DIVIDER;
            sTag = "CURL";
        }
    }
}

