/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.sourcemonitor;

import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorReport;
import java.util.Iterator;
import java.util.Map;

public class SourceMonitorSummary {
    private SourceMonitorSummary() {
    }

    public static String createReportSummary(SourceMonitorReport report, SourceMonitorReport previous) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href=\"sourcemonitor\">SourceMonitor Results</a>");
        builder.append("\n");
        return builder.toString();
    }

    public static String createReportSummaryDetails(SourceMonitorReport report, SourceMonitorReport previousReport) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map<String, String>> iteratorPrevious = null;
        if (previousReport != null) {
            iteratorPrevious = previousReport.getCheckpoints().iterator();
        }
        for (Map<String, String> checkpoint : report.getCheckpoints()) {
            builder.append("<li>");
            builder.append("Number of Lines :");
            builder.append(checkpoint.get("M0"));
            if (previousReport != null) {
                Map<String, String> previousCheckpoint = iteratorPrevious.next();
                SourceMonitorSummary.printDifference(Integer.parseInt(checkpoint.get("M0")), Integer.parseInt(previousCheckpoint.get("M10")), builder);
            }
            builder.append("</li>");
        }
        return builder.toString();
    }

    private static void printDifference(int current, int previous, StringBuilder builder) {
        float difference = current - previous;
        builder.append(" (");
        if (difference >= 0.0f) {
            builder.append('+');
        }
        builder.append(difference);
        builder.append(")");
    }
}

