/*
 * Decompiled with CFR 0.152.
 */
package com.testvagrant.optimuscloud.remote;

import com.testvagrant.optimuscloud.IOptimusCloudManager;
import com.testvagrant.optimuscloud.clients.AkiraClient;
import com.testvagrant.optimuscloud.entities.MobileDriverDetails;
import com.testvagrant.optimuscloud.entities.SessionInfo;
import com.testvagrant.optimuscloud.entities.SessionReservationDetails;
import com.testvagrant.optimuscloud.entities.SessionState;
import com.testvagrant.optimuscloud.entities.SessionsByPlatform;
import com.testvagrant.optimuscloud.utils.BuildNoGenerater;
import java.util.Arrays;

public class OptimusCloudManager
implements IOptimusCloudManager {
    private BuildNoGenerater buildNoGenerater = new BuildNoGenerater();
    private AkiraClient akiraClient = new AkiraClient();

    @Override
    public SessionInfo reserveAndroidSession() {
        return this.reserveAndroidSession(1);
    }

    @Override
    public SessionInfo reserveAndroidSession(int numOfAndroidSessionsToBeReserved) {
        return this.reserveAndroidSession(null, numOfAndroidSessionsToBeReserved);
    }

    @Override
    public SessionInfo reserveAndroidSession(String buildNo) {
        return this.reserveAndroidSession(buildNo, 1);
    }

    @Override
    public SessionInfo reserveAndroidSession(String buildNo, int numOfAndroidSessionsToBeReserved) {
        return this.reserveSession(buildNo, numOfAndroidSessionsToBeReserved, "Android");
    }

    @Override
    public SessionInfo reserveIosSession() {
        return this.reserveIosSession(null);
    }

    @Override
    public SessionInfo reserveIosSession(String buildNo) {
        return this.reserveIosSession(null, 1);
    }

    @Override
    public SessionInfo reserveIosSession(int numOfIosSessionsToBeReserved) {
        return this.reserveSession(null, numOfIosSessionsToBeReserved, "IOS");
    }

    @Override
    public SessionInfo reserveIosSession(String buildNo, int numOfIosSessionsToBeReserved) {
        return this.reserveSession(buildNo, numOfIosSessionsToBeReserved, "IOS");
    }

    @Override
    public SessionInfo reserveAndroidAndIosSessions(int androidSessions, int iosSessions) {
        return this.reserveAndroidAndIosSessions(null, androidSessions, iosSessions);
    }

    @Override
    public SessionInfo reserveAndroidAndIosSessions(String buildNoVal, int androidSessions, int iosSessions) {
        String buildNo = this.getBuildNo(buildNoVal);
        SessionReservationDetails sessionReservationDetails = new SessionReservationDetails();
        sessionReservationDetails.setBuildNo(buildNo);
        SessionsByPlatform androidSessionDetails = this.getSessionsByPlatform("Android", androidSessions);
        SessionsByPlatform iosSessionDetails = this.getSessionsByPlatform("IOS", iosSessions);
        sessionReservationDetails.setSessionDetails(Arrays.asList(androidSessionDetails, iosSessionDetails));
        return this.reserveSession(sessionReservationDetails);
    }

    private SessionsByPlatform getSessionsByPlatform(String platformName, int numOfSessionsToBeReserved) {
        SessionsByPlatform sessionByPlatform = new SessionsByPlatform();
        sessionByPlatform.setPlatformName(platformName);
        sessionByPlatform.setSessionsRequired(numOfSessionsToBeReserved);
        return sessionByPlatform;
    }

    @Override
    public SessionInfo reserveSession(int numOfSessionsToBeReserved, String platformsToBeReserved) {
        return this.reserveSession(null, numOfSessionsToBeReserved, platformsToBeReserved);
    }

    @Override
    public SessionInfo reserveSession(String buildNoVal, int numOfSessionsToBeReserved, String platformsToBeReserved) {
        String buildNo = this.getBuildNo(buildNoVal);
        SessionReservationDetails sessionReservationDetails = new SessionReservationDetails();
        sessionReservationDetails.setBuildNo(buildNo);
        SessionsByPlatform sessionsByPlatform = new SessionsByPlatform();
        sessionsByPlatform.setPlatformName(platformsToBeReserved);
        sessionsByPlatform.setSessionsRequired(numOfSessionsToBeReserved);
        sessionReservationDetails.setSessionDetails(Arrays.asList(sessionsByPlatform));
        SessionReservationDetails sessionsReserved = this.akiraClient.reserveSessions(sessionReservationDetails);
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setBuildNo(buildNo);
        sessionInfo.setSessionsReserved(sessionsReserved.getTotalSessions());
        return sessionInfo;
    }

    private SessionInfo reserveSession(SessionReservationDetails sessionReservationDetails) {
        SessionReservationDetails sessionsReserved = this.akiraClient.reserveSessions(sessionReservationDetails);
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setBuildNo(sessionReservationDetails.getBuildNo());
        sessionInfo.setSessionsReserved(sessionsReserved.getTotalSessions());
        return sessionInfo;
    }

    @Override
    public void unReserveSession(String buildNo) {
        this.akiraClient.unReserveSession(buildNo);
    }

    @Override
    public void engageSession(String sessionUrl) {
        this.akiraClient.engageSession(sessionUrl);
    }

    @Override
    public void releaseSession(MobileDriverDetails mobileDriverDetails) {
        this.akiraClient.releaseSession(mobileDriverDetails.getSessionUrl());
    }

    @Override
    public void terminateSession(String sessionUrl) {
        this.akiraClient.terminateSession(sessionUrl);
    }

    @Override
    public SessionState getSessionState(String sessionUrl) {
        return this.akiraClient.getCurrentSessionState(sessionUrl);
    }

    private String getBuildNo(String buildNo) {
        return buildNo == null ? new BuildNoGenerater().getBuildNo() : buildNo;
    }
}

