/*
 * Decompiled with CFR 0.152.
 */
package com.testvagrant.optimuscloud.utils;

import java.util.HashMap;
import java.util.Map;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public class RetryEngine {
    private RetryTemplate retryTemplate;

    public RetryEngine(int numberOfRetries, Class<? extends Throwable> exceptionToRetry) {
        HashMap<Class<? extends Throwable>, Boolean> map = new HashMap<Class<? extends Throwable>, Boolean>();
        map.put(exceptionToRetry, true);
        this.retryTemplate = this.initRetryTemplate(numberOfRetries, map);
    }

    public RetryEngine(Class<? extends Throwable> exceptionToRetry) {
        this(100, exceptionToRetry);
    }

    public RetryEngine(int numberOfRetries, Map<Class<? extends Throwable>, Boolean> exceptionMap) {
        this.retryTemplate = this.initRetryTemplate(numberOfRetries, exceptionMap);
    }

    public RetryEngine(Map<Class<? extends Throwable>, Boolean> exceptionMap) {
        this(10, exceptionMap);
    }

    private RetryTemplate initRetryTemplate(int numberOfRetries, Map<Class<? extends Throwable>, Boolean> exceptionMap) {
        RetryTemplate retryTemplate = new RetryTemplate();
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(5000L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)fixedBackOffPolicy);
        SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy(numberOfRetries, exceptionMap);
        retryTemplate.setRetryPolicy((RetryPolicy)simpleRetryPolicy);
        return retryTemplate;
    }

    public void execute(RetryCallback retryCallback) {
        this.retryTemplate.execute(retryCallback);
    }
}

