package com.testvagrant.optimuscloud.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigurationLoader {


    private static Properties properties;

    public ConfigurationLoader() {
        InputStream resourceAsStream = getClass().getClassLoader().getResourceAsStream(getConfigFileName() + ".properties");
        try {
            properties = new Properties();
            if(resourceAsStream!=null)
                properties.load(resourceAsStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getAkiraHost() {
        return properties.getProperty("optimus-cloud",System.getProperty("optimus-cloud","http://localhost:6889"));
    }

    protected String getMdbHost() {
        return properties.getProperty("mdb",System.getProperty("mdb","http://localhost:9909"));
    }

    protected String getMatchMakerHost() {
        return properties.getProperty("match-maker",System.getProperty("match-maker","http://localhost:6898"));
    }

    protected String getRabbitMQHost(){return properties.getProperty("rabbitmq",System.getProperty("rabbitmq","http://localhost:5672"));}

    private String getConfigFileName() {
        return System.getProperty("config","config");
    }


}
