package com.testvagrant.optimuscloud.clients;

import com.testvagrant.optimuscloud.configuration.OptimusCloudConfiguration;
import com.testvagrant.optimuscloud.entities.MandatoryCaps;
import com.testvagrant.optimuscloud.entities.SessionDetails;
import com.testvagrant.optimuscloud.entities.SessionReservationDetails;
import com.testvagrant.optimuscloud.entities.SessionState;
import io.restassured.response.Response;

import java.util.LinkedHashMap;

import static io.restassured.RestAssured.given;


public class AkiraClient {

    private static final String HOST = OptimusCloudConfiguration.AKIRA_HOST;

    private static final String RESERVE_SESSION = HOST+"/reserveSession";
    private static final String UNRESERVE_SESSION = HOST+"/unReserveSession";

    private static final String SESSION_STATE = HOST+"/sessionState";
    private static final String SESSION_CURRENT_STATE = "/currentState";
    private static final String ENGAGE_SESSION = SESSION_STATE+"/engage";
    private static final String RELEASE_SESSION = SESSION_STATE+"/release";
    private static final String TERMINATE_SESSION = SESSION_STATE+"/terminate";

    private static final String SESSION_CAPABILITIES = HOST+"/sessionCapabilities";

    private static final String FIND_MATCHING_SESSION_HOST = HOST+"/findMatchingSession";

    private static final String WFSMBOX = HOST+"/wfsmbox";


    public SessionReservationDetails reserveSessions(SessionReservationDetails sessionReservationDetails) {
        Response post = given()
                .header("Content-Type", "Application/json")
                .body(sessionReservationDetails)
                .post(RESERVE_SESSION);
        return post.as(SessionReservationDetails.class);
    }

    public void unReserveSession(String buildNo) {
        given()
                .header("Content-Type", "Application/json")
                .queryParam("buildNo",buildNo)
                .post(UNRESERVE_SESSION);
    }

    public SessionDetails getSessionDetails(MandatoryCaps mandatoryCaps) {
        Response matchingSessionDetails = given()
                .header("Content-Type", "Application/json")
                .queryParam("platformName", mandatoryCaps.getPlatformName())
                .queryParam("deviceType", mandatoryCaps.getDeviceType())
                .queryParam("deviceName", mandatoryCaps.getDeviceName())
                .queryParam("platformVersion", mandatoryCaps.getPlatformVersion())
                .queryParam("udid", mandatoryCaps.getUdid())
                .queryParam("buildNo", mandatoryCaps.getBuildNo())
                .get(FIND_MATCHING_SESSION_HOST);
        System.out.println("FindMatchingSessionHost="+FIND_MATCHING_SESSION_HOST);
        System.out.println("Matching session Details" +matchingSessionDetails.asString());
        return matchingSessionDetails.as(SessionDetails.class);
    }

    public SessionState getCurrentSessionState(String sessionUrl) {
        Response sessionStateResponse = given()
                .header("Content-Type", "Application/Json")
                .queryParam("sessionUrl", sessionUrl)
                .put(SESSION_CURRENT_STATE);
        return sessionStateResponse.as(SessionState.class);
    }

    public void engageSession(String sessionUrl) {
        manageSession(sessionUrl, ENGAGE_SESSION);
    }

    public void releaseSession(String sessionUrl) {
        manageSession(sessionUrl, RELEASE_SESSION);
    }

    public void terminateSession(String sessionUrl) {
        manageSession(sessionUrl,TERMINATE_SESSION);
    }

    private void manageSession(String sessionUrl, String endpoint) {
        Response sessionStateResponse = given()
                .header("Content-Type", "Application/Json")
                .queryParam("sessionUrl", sessionUrl)
                .put(endpoint);
    }

    public LinkedHashMap<String,String> getSessionCapabilities(String sessionUrl) {
        Response sessionCapabilitiesResponse = given()
                .header("Content-Type", "Application/Json")
                .queryParam("sessionUrl", sessionUrl)
                .get(SESSION_CAPABILITIES);
        LinkedHashMap<String,String> sessionCapabilitiesMap = sessionCapabilitiesResponse.as(LinkedHashMap.class);
        return sessionCapabilitiesMap;
    }


    public boolean isWfsmbox(String buildNo, String platform) {
        Response wfsmboxResp = given()
                .header("Content-Type", "Application/Json")
                .queryParam("buildNo", buildNo)
                .queryParam("platform", platform)
                .get(WFSMBOX);
        return wfsmboxResp.as(Boolean.class);
    }
}
