package com.testvagrant.optimuscloud;

import com.testvagrant.optimuscloud.entities.MobileDriverDetails;
import com.testvagrant.optimuscloud.entities.SessionInfo;
import com.testvagrant.optimuscloud.entities.SessionState;

public interface IOptimusCloudManager {

    SessionInfo reserveAndroidSession();

    SessionInfo reserveAndroidSession(int numOfAndroidSessionsToBeReserved);

    SessionInfo reserveAndroidSession(String buildNo);

    SessionInfo reserveAndroidSession(String buildNo, int numOfAndroidSessionsToBeReserved);

    SessionInfo reserveIosSession();

    SessionInfo reserveIosSession(String buildNo);

    SessionInfo reserveIosSession(int numOfIosSessionsToBeReserved);

    SessionInfo reserveIosSession(String buildNo, int numOfIosSessionsToBeReserved);

    SessionInfo reserveAndroidAndIosSessions(int androidSessions, int iosSessions);

    SessionInfo reserveAndroidAndIosSessions(String buildNoVal, int androidSessions, int iosSessions);

    SessionInfo reserveSession(int numOfSessionsToBeReserved, String platformsToBeReserved);

    SessionInfo reserveSession(String buildNo, int numOfSessionsToBeReserved, String platformsToBeReserved);

    void unReserveSession(String buildNo);

    void engageSession(String sessionUrl);

    void releaseSession(MobileDriverDetails mobileDriverDetails);

    void terminateSession(String sessionUrl);

    SessionState getSessionState(String sessionUrl);
}
