package com.testvagrant.optimuscloud.utils;

import org.json.JSONArray;
import org.json.JSONObject;
import org.openqa.selenium.remote.DesiredCapabilities;

import java.util.ArrayList;
import java.util.List;

public class TestFeedToDesiredCapConverter {

    private JSONObject appJson;
    public TestFeedToDesiredCapConverter(String testFeed) {
        JsonUtil jsonUtil = new JsonUtil();
        appJson = jsonUtil.getAppJson(testFeed);
    }

    public List<DesiredCapabilities> convert() {
        List<DesiredCapabilities> desiredCapabilitiesList = new ArrayList<>();
        JSONArray testFeedArray = (JSONArray) appJson.get("testFeed");
        for (int testFeedIterator = 0; testFeedIterator < testFeedArray.length(); testFeedIterator++) {
            JSONObject testFeedJSON = (JSONObject) testFeedArray.get(testFeedIterator);

            System.out.println("updated testFeed -- " + testFeedJSON.toString());
            DesiredCapabilities desiredCapabilities = new CapabilitiesBuilder(testFeedJSON).buildCapabilities();
            desiredCapabilitiesList.add(desiredCapabilities);
        }
        return desiredCapabilitiesList;
    }
}
