package com.testvagrant.optimuscloud.remote;

import com.testvagrant.optimuscloud.IOptimusCloudManager;
import com.testvagrant.optimuscloud.clients.AkiraClient;
import com.testvagrant.optimuscloud.entities.*;
import com.testvagrant.optimuscloud.utils.BuildNoGenerater;

import java.util.Arrays;

public class OptimusCloudManager implements IOptimusCloudManager {

    private BuildNoGenerater buildNoGenerater;
    private AkiraClient akiraClient;

    public OptimusCloudManager() {
        buildNoGenerater = new BuildNoGenerater();
        akiraClient = new AkiraClient();
    }

    @Override
    public SessionInfo reserveAndroidSession() {
        return reserveAndroidSession(1);
    }

    @Override
    public SessionInfo reserveAndroidSession(int numOfAndroidSessionsToBeReserved) {
        return reserveAndroidSession(null,numOfAndroidSessionsToBeReserved);
    }

    @Override
    public SessionInfo reserveAndroidSession(String buildNo) {
        return reserveAndroidSession(buildNo,1);
    }

    @Override
    public SessionInfo reserveAndroidSession(String buildNo, int numOfAndroidSessionsToBeReserved) {
        return reserveSession(buildNo,numOfAndroidSessionsToBeReserved,"Android");
    }

    @Override
    public SessionInfo reserveIosSession() {
        return reserveIosSession(null);
    }

    @Override
    public SessionInfo reserveIosSession(String buildNo) {
        return reserveIosSession(null,1);
    }

    @Override
    public SessionInfo reserveIosSession(int numOfIosSessionsToBeReserved) {
        return reserveSession(null,numOfIosSessionsToBeReserved, "IOS");
    }

    @Override
    public SessionInfo reserveIosSession(String buildNo, int numOfIosSessionsToBeReserved) {
        return reserveSession(buildNo,numOfIosSessionsToBeReserved, "IOS");
    }

    @Override
    public SessionInfo reserveAndroidAndIosSessions(int androidSessions, int iosSessions) {
        return reserveAndroidAndIosSessions(null,androidSessions, iosSessions);
    }

    @Override
    public SessionInfo reserveAndroidAndIosSessions(String buildNoVal, int androidSessions, int iosSessions) {
        String buildNo = getBuildNo(buildNoVal);
        SessionReservationDetails sessionReservationDetails = new SessionReservationDetails();
        sessionReservationDetails.setBuildNo(buildNo);
        SessionsByPlatform androidSessionDetails = getSessionsByPlatform("Android",androidSessions);
        SessionsByPlatform iosSessionDetails = getSessionsByPlatform("IOS",iosSessions);
        sessionReservationDetails.setSessionDetails(Arrays.asList(androidSessionDetails,iosSessionDetails));
        return reserveSession(sessionReservationDetails);
    }

    private SessionsByPlatform getSessionsByPlatform(String platformName, int numOfSessionsToBeReserved) {
        SessionsByPlatform sessionByPlatform = new SessionsByPlatform();
        sessionByPlatform.setPlatformName(platformName);
        sessionByPlatform.setSessionsRequired(numOfSessionsToBeReserved);
        return sessionByPlatform;
    }

    @Override
    public SessionInfo reserveSession(int numOfSessionsToBeReserved, String platformsToBeReserved) {
        return reserveSession(null,numOfSessionsToBeReserved,platformsToBeReserved);
    }

    @Override
    public SessionInfo reserveSession(String buildNoVal, int numOfSessionsToBeReserved, String platformsToBeReserved) {
        String buildNo = getBuildNo(buildNoVal);
        SessionReservationDetails sessionReservationDetails = new SessionReservationDetails();
        sessionReservationDetails.setBuildNo(buildNo);
        SessionsByPlatform sessionsByPlatform = new SessionsByPlatform();
        sessionsByPlatform.setPlatformName(platformsToBeReserved);
        sessionsByPlatform.setSessionsRequired(numOfSessionsToBeReserved);
        sessionReservationDetails.setSessionDetails(Arrays.asList(sessionsByPlatform));
        SessionReservationDetails sessionsReserved =  akiraClient.reserveSessions(sessionReservationDetails);
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setBuildNo(buildNo);
        sessionInfo.setSessionsReserved(sessionsReserved.getTotalSessions());
        return sessionInfo;
    }

    private SessionInfo reserveSession(SessionReservationDetails sessionReservationDetails) {
        SessionReservationDetails sessionsReserved =  akiraClient.reserveSessions(sessionReservationDetails);
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setBuildNo(sessionReservationDetails.getBuildNo());
        sessionInfo.setSessionsReserved(sessionsReserved.getTotalSessions());
        return sessionInfo;
    }

    @Override
    public void unReserveSession(String buildNo) {
        akiraClient.unReserveSession(buildNo);
    }

    @Override
    public void engageSession(String sessionUrl) {
        akiraClient.engageSession(sessionUrl);
    }

    @Override
    public void releaseSession(MobileDriverDetails mobileDriverDetails) {
        akiraClient.releaseSession(mobileDriverDetails.getSessionUrl());
    }

    @Override
    public void terminateSession(String sessionUrl) {
        akiraClient.terminateSession(sessionUrl);
    }

    @Override
    public SessionState getSessionState(String sessionUrl) {
        return akiraClient.getCurrentSessionState(sessionUrl);
    }

    private String getBuildNo(String buildNo) {
        return buildNo==null?new BuildNoGenerater().getBuildNo():buildNo;
    }
}
