package com.testvagrant.optimuscloud.driver;

import io.appium.java_client.MobileDriver;
import io.appium.java_client.ios.IOSDriver;
import org.openqa.selenium.Capabilities;

import java.net.MalformedURLException;
import java.net.URL;

public class IosDriverCreator extends DriverCreator {

    IosDriverCreator(String sessionUrl, Capabilities desiredCapabilities) {
        super(sessionUrl,desiredCapabilities);
    }

    @Override
    public MobileDriver getDriver() throws MalformedURLException {
        return new IOSDriver(new URL(sessionUrl),desiredCapabilities);
    }
}
