/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.modules.crash;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public class NativeCrashHandler {
    public static final int OK = 0;
    public static final int ALREADY_INITIALIZED = 1;
    public static final int ERROR_DURING_SIGNAL_HANDLER = 2;
    public static Object delegate;
    public static boolean loaded = false;
    public static String TAG = "TESTFAIRYSDK";

    public static void loadNativeLibrary() {
        if (loaded) {
            return;
        }
        Log.d((String)TAG, (String)"Loading native lib");
        System.loadLibrary("testfairy-lib");
        Log.d((String)TAG, (String)"Loaded native lib");
        loaded = true;
    }

    public static void logInitializationResult(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    Log.e((String)TAG, (String)"Native crash handler couldn't be initialized due to invalid signal handler.");
                }
            } else {
                Log.w((String)TAG, (String)"Native crash handler can't be initialized twice.");
            }
        } else {
            Log.i((String)TAG, (String)"Native crash handler initialized.");
        }
    }

    public static void reportNativeCrash(String string, String string2) {
        string2 = NativeCrashHandler.universalize(NativeCrashHandler.fixNativeBacktrace(string2), string);
        Log.v((String)TAG, (String)("Crash occurred in native code: " + string + "\n" + string2));
        Class<?> clazz = delegate.getClass();
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        try {
            classArray[1] = String.class;
            clazz.getDeclaredMethod("didCrash", classArray).invoke(delegate, string, string2);
        }
        catch (Throwable throwable) {
            Log.v((String)TAG, (String)"Throwable during reportNativeCrash", (Throwable)throwable);
        }
    }

    public static int initializeCrashHandler(Object object, String string) {
        Log.v((String)TAG, (String)("Native crash handler was initialized with delegate: " + object));
        delegate = object;
        return NativeCrashHandler.initialize(string);
    }

    public static void deinitializeCrashHandler() {
        Log.v((String)TAG, (String)"Native crash handler was deinitialized.");
        delegate = null;
        NativeCrashHandler.deinitialize();
    }

    public static String fixNativeBacktrace(String charSequence) {
        LinkedList<String> linkedList;
        StringBuilder stringBuilder;
        String string = charSequence;
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        LinkedList<String> linkedList2 = linkedList;
        linkedList = new LinkedList<String>();
        int n = 0;
        for (String string2 : string.split("\n")) {
            if (string2.endsWith("backtrace:")) {
                CharSequence charSequence2 = charSequence;
                n = 1;
                ((StringBuilder)charSequence2).append(string2);
                ((StringBuilder)charSequence2).append('\n');
                continue;
            }
            if (n == 0) {
                CharSequence charSequence3 = charSequence;
                ((StringBuilder)charSequence3).append(string2);
                ((StringBuilder)charSequence3).append('\n');
                continue;
            }
            linkedList2.add(string2);
        }
        n = linkedList2.size();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence4 = charSequence;
            ((StringBuilder)charSequence4).append((String)linkedList2.remove(0));
            ((StringBuilder)charSequence4).append('\n');
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public static String universalize(String stringArray, String string) {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        HashMap hashMap4;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Object object = UUID.randomUUID().toString();
        Object object2 = NativeCrashHandler.getNowAsISO();
        Object object32 = NativeCrashHandler.findFingerPrint((String)stringArray);
        Object object4 = NativeCrashHandler.findRevision((String)stringArray);
        String string2 = NativeCrashHandler.findABI((String)stringArray);
        a a2 = NativeCrashHandler.findProcessInfo((String)stringArray);
        Object object52 = NativeCrashHandler.findSignalInfo((String)stringArray);
        String string3 = NativeCrashHandler.findRegisters((String)stringArray);
        String string4 = NativeCrashHandler.findBacktrace((String)stringArray);
        String string5 = NativeCrashHandler.findVersion();
        String string6 = "Android " + Build.VERSION.RELEASE + "(" + Build.VERSION.SDK_INT + ")";
        Object object6 = System.getProperty("os.version");
        stringBuilder2.append("Incident Identifier: " + (String)object32 + "-" + (String)object4 + "-" + (String)object + "\n").append("CrashReporter Key:   " + (String)object + "\n").append("Hardware Model:      Android " + NativeCrashHandler.getDeviceName() + "\n").append("Process:         " + a2.b + "[" + a2.a + "]\n").append("Identifier:      " + a2.c + "\n").append("Version:         " + string5 + "\n").append("Code Type:       " + string2.toUpperCase(Locale.ENGLISH) + "\n").append("Parent Process:  ??? [1]\n").append("\n").append("Date/Time:       " + (String)object2 + "\n").append("OS Version:      " + string6 + " - Vendor OS: " + (String)object6 + "\n").append("Report Version:  ?\n").append("\n").append("Exception Type:  " + object52.a + "\n").append("Exception Codes: " + object52.b + "\n").append("Crashed Thread:  ?\n").append("\n").append("Thread ? Crashed:\n");
        object = hashMap4;
        hashMap4 = new HashMap();
        object2 = hashMap3;
        hashMap3 = new HashMap();
        object32 = hashMap2;
        hashMap2 = new HashMap();
        object4 = hashMap;
        hashMap = new HashMap();
        int n = 0;
        object52 = string4.split("\n");
        int n2 = ((String[])object52).length;
        for (int i = 0; i < n2; ++i) {
            StringBuilder stringBuilder3;
            String[] stringArray2;
            block51: {
                block50: {
                    String string7;
                    long l;
                    block49: {
                        block48: {
                            block47: {
                                object6 = object52[i].trim().split(" ");
                                int n3 = ((String[])object6).length;
                                if (object6[n3 - 1].length() != 40) break block47;
                                Object object7 = object;
                                String string8 = object6[4];
                                String[] stringArray3 = object6;
                                int n4 = ((String[])object6).length;
                                object7.put(string8, stringArray3[n4 - 1]);
                            }
                            Object object8 = object2;
                            String[] stringArray4 = object6;
                            String[] stringArray5 = object6;
                            stringArray2 = object6[4].split("/");
                            l = Long.valueOf(stringArray5[2], 16);
                            string7 = (String)object8.get(stringArray4[4]);
                            if (string7 == null) break block48;
                            if (Long.valueOf(string7.substring(2), 16) < l) break block49;
                        }
                        object2.put(object6[4], "0x" + object6[2]);
                    }
                    string7 = (String)object32.get(object6[4]);
                    if (string7 == null) break block50;
                    if (Long.valueOf(string7.substring(2), 16) > l) break block51;
                }
                object32.put(object6[4], "0x" + object6[2]);
            }
            StringBuilder stringBuilder4 = stringBuilder2;
            int n5 = n;
            Object object9 = object4;
            String string9 = object6[4];
            String[] stringArray6 = stringArray2;
            int n6 = stringArray2.length;
            object9.put(string9, stringArray6[n6 - 1]);
            StringBuilder stringBuilder5 = stringBuilder4.append(n5).append("\t");
            String[] stringArray7 = stringArray2;
            int n7 = stringArray2.length;
            stringBuilder5.append(stringArray7[n7 - 1]);
            int n8 = 0;
            while (true) {
                String[] stringArray8 = stringArray2;
                int n9 = stringArray2.length;
                if (n8 >= 5 - stringArray8[n9 - 1].length() / 8) break;
                stringBuilder2.append("\t");
                ++n8;
            }
            stringBuilder2.append("0x" + object6[2]).append("\t");
            n8 = 5;
            while (true) {
                if (n8 >= ((String[])object6).length - 1) break;
                stringBuilder2.append(object6[n8]).append(" ");
                ++n8;
            }
            StringBuilder stringBuilder6 = stringBuilder2;
            StringBuilder stringBuilder7 = new StringBuilder().append("(in ");
            String[] stringArray9 = stringArray2;
            int n10 = stringArray2.length;
            try {
                stringBuilder3 = stringBuilder6.append(stringBuilder7.append(stringArray9[n10 - 1]).append(")\n").toString());
            }
            catch (Throwable throwable) {
                stringBuilder3 = stringBuilder2.append(n).append("   ").append("?").append("\n");
            }
            ++n;
            continue;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        stringBuilder2.append("\n").append("Thread ? crashed with " + string2.toUpperCase(Locale.ENGLISH) + " Thread State:\n").append(string3).append("\n\n").append("Binary Images:\n");
        for (Object object52 : object.keySet()) {
            string3 = (String)object2.get(object52);
            String string10 = (String)object32.get(object52);
            String string11 = (String)object4.get(object52);
            object6 = "<" + (String)object.get(object52) + ">";
            if (string3 == null) {
                if (string10 == null) continue;
                string3 = string10;
            } else if (string10 == null) {
                string10 = string3;
            } else {
                String string12 = string3;
                string3 = string10;
                string10 = string12;
            }
            stringBuilder2.append(string10).append(" - ").append(string3).append(' ').append(string11).append(' ').append(string2).append(' ').append((String)object6).append(' ').append((String)object52).append('\n');
        }
        stringBuilder2.append("\n\n\n");
        for (Object object32 : stringArray.split("\n")) {
            if (((String)object32).contains("signal")) {
                stringBuilder2.append((String)object32).append('\n').append("Abort message: ").append(string).append('\n');
                continue;
            }
            if (((String)object32).trim().startsWith("#")) {
                String[] stringArray10 = ((String)object32).split(" ");
                object4 = stringArray10[stringArray10.length - 1];
                if (((String)object4).length() == 40) {
                    Object object10;
                    Object object11;
                    Object object12;
                    Object object13;
                    Object object14;
                    Object object15;
                    StringBuilder stringBuilder8;
                    try {
                        stringBuilder8 = stringBuilder2;
                        object15 = object32;
                        Object object16 = object4;
                        object14 = object16;
                        object13 = object16;
                        object12 = object16;
                        object11 = object16;
                        object10 = object16;
                        Long.valueOf(((String)object16).substring(0, 8), 16);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    Long.valueOf(((String)object12).substring(8, 16), 16);
                    Long.valueOf(((String)object11).substring(16, 24), 16);
                    Long.valueOf(((String)object10).substring(24, 32), 16);
                    Long.valueOf(((String)object14).substring(32, 40), 16);
                    stringBuilder8.append(((String)object15).replace((CharSequence)object13, "")).append('\n');
                    continue;
                }
            }
            stringBuilder2.append((String)object32).append('\n');
        }
        return stringBuilder2.toString();
    }

    public static String getNowAsISO() {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'", Locale.US);
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(new Date());
    }

    /*
     * Unable to fully structure code
     */
    public static String findVersion() {
        block11: {
            var0 = "?";
            var1_1 = NativeCrashHandler.delegate.getClass().getDeclaredField("appContext");
            var2_2 = var1_1.isAccessible();
            var1_1.setAccessible(true);
            var3_3 = (Context)var1_1.get(NativeCrashHandler.delegate);
            var3_3 = var3_3.getPackageManager().getPackageInfo(var3_3.getPackageName(), 0);
            if (Build.VERSION.SDK_INT < 28) break block11;
            try {
                v0 = new StringBuilder().append(var3_3.versionName).append(" (").append(var3_3.getLongVersionCode()).append(")");
lbl15:
                // 2 sources

                while (true) {
                    var0 = v0.toString();
                    ** GOTO lbl23
                    break;
                }
            }
            catch (Throwable v1) {}
        }
        v0 = new StringBuilder().append(var3_3.versionName).append(" (").append(var3_3.versionCode).append(")");
        ** continue;
lbl23:
        // 1 sources

        var1_1.setAccessible(var2_2);
        return var0;
    }

    public static String findLineContaining(String stringArray, String string, String string2) {
        for (String string3 : stringArray.split("\n")) {
            if (!string3.contains(string)) continue;
            return string3.replace("'", "");
        }
        return string2;
    }

    public static String findFingerPrint(String string) {
        return NativeCrashHandler.findLineContaining(string, "Build fingerprint:", "Build fingerprint: <unknown>").split("Build fingerprint:")[1].trim();
    }

    public static String findRevision(String string) {
        return NativeCrashHandler.findLineContaining(string, "Revision:", "Revision: <unknown>").split("Revision:")[1].trim();
    }

    public static String findABI(String string) {
        return NativeCrashHandler.findLineContaining(string, "ABI:", "ABI: <unknown>").split("ABI:")[1].trim();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static a findProcessInfo(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        block22: {
            block20: {
                block18: {
                    string5 = "<unknown>";
                    string4 = "pid: <unknown>, tid: <unknown>, name: <unknown   >>> <unknown> <<<";
                    try {
                        String string6 = NativeCrashHandler.findLineContaining(string, "pid:", string4);
                        String string7 = string;
                        string = NativeCrashHandler.findLineContaining(string7, "tid:", string4);
                        string3 = NativeCrashHandler.findLineContaining(string7, "name:", string4);
                        string4 = NativeCrashHandler.findLineContaining(string7, " >>> ", string4);
                        try {
                            string2 = string6.split("pid: ")[1].split(",")[0].trim();
                            break block18;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    catch (Throwable throwable) {
                        string3 = string5;
                        string = string5;
                        string2 = string5;
                        return new a(string2, string, string3, string5);
                    }
                    string2 = string5;
                }
                try {
                    string = string.split("tid: ")[1].split(",")[0].trim();
                    break block20;
                }
                catch (Throwable throwable) {
                    string3 = string5;
                    string = string5;
                    return new a(string2, string, string3, string5);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {}
                string = string5;
            }
            try {
                string3 = string3.split("name: ")[1].split(" >>> ")[0].trim();
                break block22;
            }
            catch (Throwable throwable) {
                string3 = string5;
                return new a(string2, string, string3, string5);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {}
            string3 = string5;
        }
        try {
            string5 = string4.split(">>> ")[1].split(" <<<")[0].trim();
            return new a(string2, string, string3, string5);
        }
        catch (Throwable throwable) {
            return new a(string2, string, string3, string5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new a(string2, string, string3, string5);
        }
        catch (NullPointerException nullPointerException) {}
        return new a(string2, string, string3, string5);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static b findSignalInfo(String string) {
        String string2;
        String string3;
        String string4;
        block16: {
            block14: {
                string4 = "<unknown>";
                string3 = "signal <unknown> (<unknown>), code <unknown> (<unknown>), fault addr <unknown>";
                try {
                    String string5 = NativeCrashHandler.findLineContaining(string, "signal ", string3);
                    String string6 = string;
                    string = NativeCrashHandler.findLineContaining(string6, "code ", string3);
                    string3 = NativeCrashHandler.findLineContaining(string6, "fault addr ", string3);
                    try {
                        string2 = string5.split("signal ")[1].split(" ")[1].replace("(", "").replace("),", "").trim();
                        break block14;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                catch (Throwable throwable) {
                    string = string4;
                    string2 = string4;
                    return new b(string2, string, string4);
                }
                string2 = string4;
            }
            try {
                string = string.split("code ")[1].split(" ")[1].replace("(", "").replace("),", "").trim();
                break block16;
            }
            catch (Throwable throwable) {
                string = string4;
                return new b(string2, string, string4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {}
            string = string4;
        }
        try {
            string4 = string3.split("fault addr ")[1].trim();
            return new b(string2, string, string4);
        }
        catch (Throwable throwable) {
            return new b(string2, string, string4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new b(string2, string, string4);
        }
        catch (NullPointerException nullPointerException) {}
        return new b(string2, string, string4);
    }

    public static String findRegisters(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        String[] stringArray = string.split("\n");
        int n4 = stringArray.length;
        for (n = 0; n < n4; ++n) {
            if (stringArray[n].contains("fault addr")) {
                ++n2;
                break;
            }
            ++n2;
        }
        n4 = stringArray.length;
        for (n = 0; n < n4; ++n) {
            if (stringArray[n].contains("backtrace:")) {
                --n3;
                break;
            }
            ++n3;
        }
        if (n2 > 0 && n3 > 0) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            while (n2 < n3) {
                for (String string2 : stringArray[n2].split(" ")) {
                    if (string2.length() < 8 && string2.length() > 1 && string2.charAt(0) != ' ') {
                        stringArray[n2] = stringArray[n2].replace(string2 + " ", string2 + ": ");
                        continue;
                    }
                    if (string2.length() != 8 && string2.length() != 16 && string2.length() != 32 && string2.length() != 64) continue;
                    stringArray[n2] = stringArray[n2].replaceFirst(" " + string2, " 0x" + string2);
                }
                stringBuilder2.append(stringArray[n2]).append("\n");
                ++n2;
            }
            return stringBuilder2.toString();
        }
        return "";
    }

    public static String findBacktrace(String charSequence) {
        StringBuilder stringBuilder;
        String string = charSequence;
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = 0;
        String[] stringArray = string.split("\n");
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (stringArray[i].contains("backtrace:")) {
                ++n;
                break;
            }
            ++n;
        }
        if (n > 0) {
            while (n < stringArray.length) {
                ((StringBuilder)charSequence).append(stringArray[n]).append("\n");
                ++n;
            }
            return ((StringBuilder)charSequence).toString();
        }
        return "";
    }

    public static String getDeviceName() {
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        if (string.startsWith(string2)) {
            return NativeCrashHandler.capitalize(string);
        }
        return NativeCrashHandler.capitalize(string2) + " " + string;
    }

    public static String capitalize(String object) {
        StringBuilder stringBuilder;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return object;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        boolean bl = true;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = object[i];
            if (bl && Character.isLetter((char)object2)) {
                stringBuilder2.append(Character.toUpperCase((char)object2));
                bl = false;
                continue;
            }
            if (Character.isWhitespace((char)object2)) {
                bl = true;
            }
            stringBuilder2.append((char)object2);
        }
        return stringBuilder2.toString();
    }

    public static native void crashIntentionally();

    public static native int initialize(String var0);

    public static native boolean deinitialize();

    public static final class b {
        public final String a;
        public final String b;

        public b(String string, String string2, String string3) {
            this.a = string;
            this.b = string2;
        }
    }

    public static final class a {
        public final String a;
        public final String b;
        public final String c;

        public a(String string, String string2, String string3, String string4) {
            this.a = string;
            this.b = string3;
            this.c = string4;
        }
    }
}

