/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIFramework;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIRole;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APIUserFile;
import com.testdroid.api.util.TimeConverter;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class APIUser
extends APIEntity {
    private List<Long> serviceIds;
    private Long accountId;
    private List<Long> accountServiceIds;
    private String address;
    private String city;
    private String code;
    private String country;
    private Date createTime;
    private Date deleteTime;
    private String email;
    private Boolean enabled;
    private Boolean isMainUser;
    private Date lastLoginTime;
    private Date lastLaunchedTestTime;
    private String mainUserEmail;
    private Long mainUserId;
    private String firstName;
    private String lastName;
    private String organization;
    private String phone;
    private List<APIRole> roles;
    private String state;
    private Status status;
    private String timeZone;
    private String vatId;
    private String apiKey;
    private Long createdById;
    private String createdByEmail;
    private String mfaQRCodeUrl;
    private MfaStatus mfaStatus;
    private String registrationIP;
    private Boolean sdcSync;
    private Collection<APIUser> accountOwners;

    public APIUser() {
    }

    public APIUser(Long id, String email, String firstName, String lastName, LocalDateTime createTime, LocalDateTime deleteTime, Status status) {
        super(id);
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.createTime = TimeConverter.toDate(createTime);
        this.deleteTime = TimeConverter.toDate(deleteTime);
        this.status = status;
        this.enabled = status == Status.ENABLED;
    }

    public APIUser(Long id, Long accountId, String email, String firstName, String lastName, String state, String country, String city, String code, String address, String phone, String organization, String vatId, String timeZone, LocalDateTime createTime, LocalDateTime deleteTime, LocalDateTime lastLoginTime, LocalDateTime lastLaunchedTestTime, Boolean isMainUser, Long mainUserId, String mainUserEmail, String apiKey, Status status, Long createdById, String createdByEmail, MfaStatus mfaStatus, String registrationIP, Boolean sdcSync) {
        this(id, email, firstName, lastName, createTime, deleteTime, status);
        this.state = state;
        this.country = country;
        this.city = city;
        this.code = code;
        this.address = address;
        this.phone = phone;
        this.organization = organization;
        this.vatId = vatId;
        this.timeZone = timeZone;
        this.lastLoginTime = TimeConverter.toDate(lastLoginTime);
        this.lastLaunchedTestTime = TimeConverter.toDate(lastLaunchedTestTime);
        this.accountId = accountId;
        this.isMainUser = isMainUser;
        this.mainUserId = mainUserId;
        this.mainUserEmail = mainUserEmail;
        this.apiKey = apiKey;
        this.createdById = createdById;
        this.createdByEmail = createdByEmail;
        this.mfaStatus = mfaStatus;
        this.registrationIP = registrationIP;
        this.selfURI = String.format("/users/%s", id);
        this.sdcSync = sdcSync;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getVatId() {
        return this.vatId;
    }

    public void setVatId(String vatId) {
        this.vatId = vatId;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getIsMainUser() {
        return this.isMainUser;
    }

    public void setIsMainUser(Boolean isMainUser) {
        this.isMainUser = isMainUser;
    }

    public List<APIRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<APIRole> roles) {
        this.roles = roles;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.enabled = status == Status.ENABLED;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public Date getLastLaunchedTestTime() {
        return this.lastLaunchedTestTime;
    }

    public void setLastLaunchedTestTime(Date lastLaunchedTestTime) {
        this.lastLaunchedTestTime = lastLaunchedTestTime;
    }

    public Long getMainUserId() {
        return this.mainUserId;
    }

    public void setMainUserId(Long mainUserId) {
        this.mainUserId = mainUserId;
    }

    public String getMainUserEmail() {
        return this.mainUserEmail;
    }

    public void setMainUserEmail(String mainUserEmail) {
        this.mainUserEmail = mainUserEmail;
    }

    public Long getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(Long createdById) {
        this.createdById = createdById;
    }

    public String getCreatedByEmail() {
        return this.createdByEmail;
    }

    public void setCreatedByEmail(String createdByEmail) {
        this.createdByEmail = createdByEmail;
    }

    private String getProjectsURI() {
        return APIUser.createUri(this.selfURI, "/projects");
    }

    private String getProjectURI(Long id) {
        return APIUser.createUri(this.selfURI, "/projects/" + id);
    }

    private String getDeviceGroupsURI() {
        return APIUser.createUri(this.selfURI, "/device-groups");
    }

    private String getNotificationsURI() {
        return APIUser.createUri(this.selfURI, "/notifications");
    }

    private String getNotificationURI(long id) {
        return APIUser.createUri(this.selfURI, "/notifications/" + id);
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Date getDeleteTime() {
        return this.deleteTime;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    public List<Long> getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(List<Long> serviceIds) {
        this.serviceIds = serviceIds;
    }

    public List<Long> getAccountServiceIds() {
        return this.accountServiceIds;
    }

    public void setAccountServiceIds(List<Long> accountServiceIds) {
        this.accountServiceIds = accountServiceIds;
    }

    public void setMfaQRCodeUrl(String mfaQRCodeUrl) {
        this.mfaQRCodeUrl = mfaQRCodeUrl;
    }

    public String getMfaQRCodeUrl() {
        return this.mfaQRCodeUrl;
    }

    public MfaStatus getMfaStatus() {
        return this.mfaStatus;
    }

    public void setMfaStatus(MfaStatus mfaStatus) {
        this.mfaStatus = mfaStatus;
    }

    public String getRegistrationIP() {
        return this.registrationIP;
    }

    public void setRegistrationIP(String registrationIP) {
        this.registrationIP = registrationIP;
    }

    public Boolean getSdcSync() {
        return this.sdcSync;
    }

    public void setSdcSync(Boolean sdcSync) {
        this.sdcSync = sdcSync;
    }

    public void setAccountOwners(Collection<APIUser> accountOwners) {
        this.accountOwners = accountOwners;
    }

    public Collection<APIUser> getAccountOwners() {
        return this.accountOwners;
    }

    private Map<String, Object> getUpdateUserParams() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("address", this.address);
        map.put("city", this.city);
        map.put("code", this.code);
        map.put("country", this.country);
        map.put("email", this.email);
        map.put("firstName", this.firstName);
        map.put("lastName", this.lastName);
        map.put("organization", this.organization);
        map.put("phone", this.phone);
        map.put("state", this.state);
        map.put("timeZone", this.timeZone);
        map.put("vatId", this.vatId);
        return map;
    }

    private Map<String, Object> getCreateDeviceGroupParams(String displayName, APIDevice.OsType osType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayName", displayName);
        map.put("osType", (Object)osType);
        return map;
    }

    private Map<String, Object> getCreateProjectParams(String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", name);
        return result;
    }

    public APIProject createProject(String name) throws APIException {
        return this.postResource(this.getProjectsURI(), this.getCreateProjectParams(name), APIProject.class);
    }

    public void update() throws APIException {
        APIUser user = this.postResource(this.selfURI, this.getUpdateUserParams(), APIUser.class);
        this.clone(user);
    }

    public APITestRun startTestRun(APITestRunConfig config) throws APIException {
        APITestRun apiTestRun = this.postResource(APIUser.createUri(this.selfURI, "/runs"), config, APITestRun.class);
        apiTestRun.setSelfURI(APIUser.createUri(this.selfURI, String.format("/projects/%s/runs/%s", apiTestRun.getProjectId(), apiTestRun.getId())));
        return apiTestRun;
    }

    public APITestRunConfig validateTestRunConfig(APITestRunConfig config) throws APIException {
        return this.postResource(APIUser.createUri(this.selfURI, "/runs/config"), config, APITestRunConfig.class);
    }

    @JsonIgnore
    public APIUserFile uploadFile(File file) throws APIException {
        return this.postFile(APIUser.createUri(this.selfURI, "/files"), file, null, APIUserFile.class);
    }

    @JsonIgnore
    public APIUserFile getFile(Long id) throws APIException {
        return this.getResource(APIUser.createUri(this.selfURI, String.format("/files/%s", id)), APIUserFile.class).getEntity();
    }

    @JsonIgnore
    public APIListResource<APIProject> getProjectsResource() throws APIException {
        return this.getListResource(this.getProjectsURI(), APIProject.class);
    }

    @JsonIgnore
    public APIListResource<APIProject> getProjectsResource(Context<APIProject> context) throws APIException {
        return this.getListResource(this.getProjectsURI(), context);
    }

    public APIProject getProject(Long id) throws APIException {
        return this.getResource(this.getProjectURI(id), APIProject.class).getEntity();
    }

    @JsonIgnore
    public APIListResource<APIDeviceGroup> getDeviceGroupsResource() throws APIException {
        return this.getListResource(this.getDeviceGroupsURI(), APIDeviceGroup.class);
    }

    @JsonIgnore
    public APIListResource<APIDeviceGroup> getDeviceGroupsResource(Context<APIDeviceGroup> context) throws APIException {
        return this.getListResource(this.getDeviceGroupsURI(), context);
    }

    @JsonIgnore
    public APIListResource<APIFramework> getAvailableFrameworksResource(Context<APIFramework> context) throws APIException {
        return this.getListResource(APIUser.createUri(this.selfURI, "/available-frameworks"), context);
    }

    @JsonIgnore
    public APIDeviceGroup createDeviceGroup(String displayName, APIDevice.OsType osType) throws APIException {
        return this.postResource(this.getDeviceGroupsURI(), this.getCreateDeviceGroupParams(displayName, osType), APIDeviceGroup.class);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIUser apiUser = (APIUser)from;
        this.cloneBase(from);
        this.address = apiUser.address;
        this.city = apiUser.city;
        this.code = apiUser.code;
        this.country = apiUser.country;
        this.email = apiUser.email;
        this.firstName = apiUser.firstName;
        this.lastName = apiUser.lastName;
        this.organization = apiUser.organization;
        this.phone = apiUser.phone;
        this.roles = apiUser.roles;
        this.state = apiUser.state;
        this.timeZone = apiUser.timeZone;
        this.vatId = apiUser.vatId;
        this.createTime = apiUser.createTime;
        this.deleteTime = apiUser.deleteTime;
        this.isMainUser = apiUser.isMainUser;
        this.status = apiUser.status;
        this.lastLoginTime = apiUser.lastLoginTime;
        this.lastLaunchedTestTime = apiUser.lastLaunchedTestTime;
        this.mainUserId = apiUser.mainUserId;
        this.mainUserEmail = apiUser.mainUserEmail;
        this.enabled = apiUser.enabled;
        this.accountId = apiUser.accountId;
        this.apiKey = apiUser.apiKey;
        this.createdById = apiUser.createdById;
        this.createdByEmail = apiUser.createdByEmail;
        this.serviceIds = apiUser.serviceIds;
        this.accountServiceIds = apiUser.accountServiceIds;
        this.mfaStatus = apiUser.mfaStatus;
        this.mfaQRCodeUrl = apiUser.mfaQRCodeUrl;
        this.registrationIP = apiUser.registrationIP;
        this.sdcSync = apiUser.sdcSync;
        this.accountOwners = apiUser.accountOwners;
    }

    public static enum MfaStatus {
        VERIFICATION_NEED("Verification needed"),
        DISABLED("Disabled"),
        ENABLED("Enabled");

        private final String displayName;

        private MfaStatus(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    @XmlType(namespace="APIUser")
    public static enum Status {
        INACTIVE("Inactive"),
        DISABLED("Disabled"),
        ENABLED("Enabled");

        private final String displayName;

        private Status(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

