/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.formatter.CurrencyFormatter;
import com.testdroid.api.model.APIRole;
import com.testdroid.api.model.enums.Unit;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
public class APIService
extends APIEntity {
    private boolean autoRenew;
    private String externalId;
    private String commonId;
    private Integer centPrice;
    private Integer includedHours;
    private Integer pricePerHour;
    private String description;
    private String name;
    private Date archiveTime;
    private Date activateTime;
    private boolean activated;
    private boolean customPlan;
    private ChargeType chargeType;
    private List<APIRole> roles = new ArrayList<APIRole>();
    private Unit unit;
    private Set<Integer> defaultConcurrences = new HashSet<Integer>();

    public APIService() {
    }

    public APIService(Long id, String name, String description, boolean autoRenew, Integer centPrice, Integer includedHours, Integer pricePerHour, String externalId, String commonId, LocalDateTime archiveTime, LocalDateTime activateTime, boolean activated, boolean customPlan, ChargeType chargeType, Unit unit) {
        super(id);
        this.name = name;
        this.description = description;
        this.autoRenew = autoRenew;
        this.centPrice = centPrice;
        this.includedHours = includedHours;
        this.pricePerHour = pricePerHour;
        this.externalId = externalId;
        this.archiveTime = TimeConverter.toDate(archiveTime);
        this.activateTime = TimeConverter.toDate(activateTime);
        this.activated = activated;
        this.customPlan = customPlan;
        this.chargeType = chargeType;
        this.unit = unit;
        this.commonId = commonId;
    }

    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public Integer getCentPrice() {
        return this.centPrice;
    }

    public void setCentPrice(Integer centPrice) {
        this.centPrice = centPrice;
    }

    @Override
    protected <T extends APIEntity> void clone(T from) {
        APIService apiService = (APIService)from;
        this.cloneBase(from);
        this.name = apiService.name;
        this.description = apiService.description;
        this.autoRenew = apiService.autoRenew;
        this.centPrice = apiService.centPrice;
        this.externalId = apiService.externalId;
        this.commonId = apiService.commonId;
        this.includedHours = apiService.includedHours;
        this.pricePerHour = apiService.pricePerHour;
        this.archiveTime = apiService.archiveTime;
        this.activateTime = apiService.activateTime;
        this.activated = apiService.activated;
        this.customPlan = apiService.customPlan;
        this.chargeType = apiService.chargeType;
        this.unit = apiService.unit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getPriceString() {
        return CurrencyFormatter.format(this.centPrice.longValue());
    }

    public Integer getIncludedHours() {
        return this.includedHours;
    }

    public void setIncludedHours(Integer includedHours) {
        this.includedHours = includedHours;
    }

    public Integer getPricePerHour() {
        return this.pricePerHour;
    }

    public void setPricePerHour(Integer pricePerHour) {
        this.pricePerHour = pricePerHour;
    }

    public Date getArchiveTime() {
        return this.archiveTime;
    }

    public void setArchiveTime(Date archiveTime) {
        this.archiveTime = archiveTime;
    }

    public Date getActivateTime() {
        return this.activateTime;
    }

    public void setActivateTime(Date activateTime) {
        this.activateTime = activateTime;
    }

    public boolean isCustomPlan() {
        return this.customPlan;
    }

    public void setCustomPlan(boolean customPlan) {
        this.customPlan = customPlan;
    }

    public ChargeType getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(ChargeType chargeType) {
        this.chargeType = chargeType;
    }

    public List<APIRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<APIRole> roles) {
        this.roles = roles;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public Set<Integer> getDefaultConcurrences() {
        return this.defaultConcurrences;
    }

    public String getCommonId() {
        return this.commonId;
    }

    public void setCommonId(String commonId) {
        this.commonId = commonId;
    }

    public void setDefaultConcurrences(Set<Integer> defaultAvailableConcurrences) {
        this.defaultConcurrences = defaultAvailableConcurrences;
    }

    @JsonIgnore
    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    @JsonIgnore
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof APIService)) {
            return false;
        }
        APIService other = (APIService)object;
        return !(this.id == null && other.id != null || this.id != null && !this.id.equals(other.id));
    }

    @XmlType(namespace="APIService")
    public static enum ChargeType {
        USAGE_MOBILE,
        CONCURRENCY_MOBILE,
        CONCURRENCY_DESKTOP;


        public static Boolean isConcurrency(String value) {
            return !Objects.equals("metered", value);
        }

        public Boolean isConcurrency() {
            return this == CONCURRENCY_MOBILE || this == CONCURRENCY_DESKTOP;
        }

        public Boolean isUsage() {
            return this == USAGE_MOBILE;
        }
    }
}

