/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.util;

import java.nio.ByteBuffer;

public class FramePrinter {
    public static String frameToString(ByteBuffer frame) {
        if (frame == null) {
            return "[null]";
        }
        byte fb = frame.get(0);
        if (((long)fb & 0x80L) != 0L) {
            return FramePrinter.controlFrameToString(frame);
        }
        return FramePrinter.dataFrameToString(frame);
    }

    private static String controlFrameToString(ByteBuffer frame) {
        return "[C??]";
    }

    private static String dataFrameToString(ByteBuffer frame) {
        int streamId = frame.getInt(0);
        int frameLength = frame.getInt(4);
        byte frameFlags = (byte)(frameLength >> 24);
        return String.format("[D %d %d%s]", streamId, frameLength &= 0xFFFFFF, (frameFlags & 1) == 1 ? " FIN" : "");
    }
}

