/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.message;

import com.teskalabs.seacat.android.client.SeaCatClient;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class MessageTrigger
implements Runnable {
    private static final String TAG = MessageTrigger.class.getName();
    private static final String eventsAPIUrlBase = "https://api.seacat/message/trigger/";
    private final URL url;
    protected int responseCode = -1;
    protected String responseMessage = null;
    protected final ByteArrayOutputStream responseBody;

    public MessageTrigger(String eventName) throws IOException {
        this(eventsAPIUrlBase, eventName);
    }

    public MessageTrigger(String URLBase, String eventName) throws IOException {
        this.url = new URL(URLBase + eventName);
        this.responseBody = new ByteArrayOutputStream();
    }

    @Override
    public void run() {
        this.onPreExecute();
        try {
            int nRead;
            HttpURLConnection conn = SeaCatClient.open(this.url);
            conn.setConnectTimeout(1500);
            conn.setReadTimeout(1500);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("Content-Type", this.getMessageContentType());
            conn.setDoOutput(true);
            DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
            this.writeContent(outputStream);
            outputStream.close();
            InputStream is = conn.getInputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                this.responseBody.write(data, 0, nRead);
            }
            this.responseBody.flush();
            this.responseCode = conn.getResponseCode();
            this.responseMessage = conn.getResponseMessage();
            this.onPostExecute();
        }
        catch (IOException e) {
            this.onError(e);
        }
    }

    public void onPreExecute() {
    }

    public void onPostExecute() {
    }

    public void onError(IOException e) {
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public ByteArrayOutputStream getResponseBody() {
        return this.responseBody;
    }

    protected abstract String getMessageContentType();

    protected abstract void writeContent(DataOutputStream var1) throws IOException;
}

