/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.http;

import com.teskalabs.seacat.android.client.core.Reactor;
import com.teskalabs.seacat.android.client.core.SPDY;
import com.teskalabs.seacat.android.client.http.Headers;
import com.teskalabs.seacat.android.client.http.HttpDate;
import com.teskalabs.seacat.android.client.http.HttpStatus;
import com.teskalabs.seacat.android.client.http.InboundStream;
import com.teskalabs.seacat.android.client.http.OutboundStream;
import com.teskalabs.seacat.android.client.intf.IFrameProvider;
import com.teskalabs.seacat.android.client.intf.IStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class URLConnection
extends HttpURLConnection
implements IFrameProvider,
IStream {
    protected final Reactor reactor;
    protected final InboundStream inboundStream;
    protected OutboundStream outboundStream = null;
    private Headers responseHeaders = null;
    private final Headers.Builder requestHeaders = new Headers.Builder();
    private boolean launched = false;
    private int streamId = -1;
    private int priority;
    private boolean responseReady = false;
    private Lock responseReadyLock = new ReentrantLock();
    private Condition responseReadyCondition = this.responseReadyLock.newCondition();

    public URLConnection(Reactor reactor, URL u, int priority) {
        super(u);
        this.reactor = reactor;
        this.priority = priority;
        this.inboundStream = new InboundStream(reactor, this.getReadTimeout());
    }

    final void launch() throws IOException {
        if (!this.launched) {
            int contentLength;
            if (this.outboundStream != null && (contentLength = this.outboundStream.getContentLength()) > 0 && this.getRequestProperty("Content-length") == null) {
                this.outboundStream.close();
                this.setRequestProperty("Content-length", "" + contentLength);
            }
            this.launched = true;
            this.reactor.registerFrameProvider(this, true);
        }
    }

    final boolean isLaunched() {
        return this.launched;
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        this.launch();
        this.waitForResponse();
        return this.inboundStream;
    }

    @Override
    public int getResponseCode() throws IOException {
        this.launch();
        this.waitForResponse();
        return super.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResponse() throws SocketTimeoutException {
        block9: {
            long timeoutMillis = this.getConnectTimeout() + this.getReadTimeout();
            if (timeoutMillis == 0L) {
                timeoutMillis = 180000L;
            }
            long cutOfTimeMillis = System.nanoTime() / 1000000L + timeoutMillis;
            this.responseReadyLock.lock();
            block5: while (true) {
                while (!this.responseReady) {
                    long awaitMillis = cutOfTimeMillis - System.nanoTime() / 1000000L;
                    if (awaitMillis <= 0L) {
                        throw new SocketTimeoutException("Connect timeout");
                    }
                    try {
                        this.responseReadyCondition.awaitNanos(awaitMillis * 1000000L);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                break block9;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.responseReadyLock.unlock();
            }
        }
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
        }
        if (this.method.equals("GET")) {
            this.method = "POST";
        }
        if (this.outboundStream == null) {
            if (this.launched) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.outboundStream = new OutboundStream(this.reactor, this.priority);
        }
        return this.outboundStream;
    }

    @Override
    public synchronized IFrameProvider.Result buildFrame(Reactor reactor) throws IOException {
        long ifModifiedSince;
        assert (this.reactor == reactor);
        if (this.fixedContentLength > 0) {
            this.addRequestProperty("Content-length", String.format("%d", this.fixedContentLength));
        }
        if ((ifModifiedSince = this.getIfModifiedSince()) != 0L) {
            this.addRequestProperty("If-Modified-Since", HttpDate.format(new Date(ifModifiedSince)));
        }
        boolean fin_flag = this.outboundStream == null;
        ByteBuffer frame = reactor.framePool.borrow("URLConnection.buildSYN_STREAM");
        this.streamId = reactor.streamFactory.registerStream(this);
        this.inboundStream.setStreamId(this.streamId);
        SPDY.buildALX1SynStream(frame, this.streamId, this.getURL(), this.getRequestMethod(), this.getRequestHeaders(), fin_flag, this.priority);
        if (this.outboundStream != null) {
            if ((frame.get(4) & 1) != 0) {
                throw new RuntimeException();
            }
            this.outboundStream.launch(this.streamId);
        } else if ((frame.get(4) & 1) != 1) {
            throw new RuntimeException();
        }
        return new IFrameProvider.Result(frame, false);
    }

    @Override
    public int getFrameProviderPriority() {
        return this.priority;
    }

    @Override
    public void reset() {
        if (this.outboundStream != null) {
            this.outboundStream.reset();
        }
        this.inboundStream.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean receivedALX1_SYN_REPLY(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        this.responseCode = frame.getShort();
        this.responseMessage = HttpStatus.getMessage(this.responseCode);
        frame.getShort();
        Headers.Builder headerBuilder = new Headers.Builder();
        headerBuilder.add(null, "HTTP/1.1 " + this.responseCode + " " + this.responseMessage);
        while (frame.position() < frame.limit()) {
            String k = SPDY.parseVLEString(frame);
            String v = SPDY.parseVLEString(frame);
            headerBuilder.add(k, v);
        }
        this.responseHeaders = headerBuilder.build();
        this.responseReadyLock.lock();
        try {
            this.responseReady = true;
            this.responseReadyCondition.signalAll();
        }
        finally {
            this.responseReadyLock.unlock();
        }
        if ((frameFlags & 1) == 1) {
            this.inboundStream.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean receivedSPD3_RST_STREAM(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        this.reset();
        this.responseCode = 500;
        this.responseMessage = HttpStatus.getMessage(this.responseCode);
        this.responseReadyLock.lock();
        try {
            this.responseReady = true;
            this.responseReadyCondition.signalAll();
        }
        finally {
            this.responseReadyLock.unlock();
        }
        return true;
    }

    @Override
    public boolean receivedDataFrame(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        boolean ret = this.inboundStream.inboundData(frame);
        if ((frameFlags & 1) == 1) {
            this.inboundStream.close();
        }
        return ret;
    }

    @Override
    public synchronized String getHeaderField(int position) {
        if (this.responseHeaders == null) {
            return null;
        }
        return this.responseHeaders.value(position);
    }

    @Override
    public synchronized String getHeaderFieldKey(int position) {
        if (this.responseHeaders == null) {
            return null;
        }
        return this.responseHeaders.name(position);
    }

    @Override
    public synchronized String getHeaderField(String name) {
        if (this.responseHeaders == null) {
            return null;
        }
        return this.responseHeaders.get(name);
    }

    @Override
    public synchronized Map<String, List<String>> getHeaderFields() {
        if (this.responseHeaders == null) {
            return null;
        }
        TreeMap<String, List<String>> m = new TreeMap<String, List<String>>(Headers.FIELD_NAME_COMPARATOR);
        for (String name : this.responseHeaders.names()) {
            m.put(name, this.responseHeaders.values(name));
        }
        return m;
    }

    @Override
    public synchronized void setRequestProperty(String field, String newValue) {
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (newValue == null) {
            return;
        }
        this.requestHeaders.set(field, newValue);
    }

    @Override
    public synchronized void addRequestProperty(String field, String newValue) {
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (newValue == null) {
            return;
        }
        this.requestHeaders.add(field, newValue);
    }

    @Override
    public synchronized String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.requestHeaders.get(field);
    }

    @Override
    public synchronized Map<String, List<String>> getRequestProperties() {
        Headers rh = this.requestHeaders.build();
        TreeMap<String, List<String>> m = new TreeMap<String, List<String>>(Headers.FIELD_NAME_COMPARATOR);
        for (String name : rh.names()) {
            m.put(name, rh.values(name));
        }
        return m;
    }

    public synchronized Headers getRequestHeaders() {
        return this.requestHeaders.build();
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean usingProxy() {
        return true;
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        super.setReadTimeout(timeoutMillis);
        this.inboundStream.setReadTimeout(this.getReadTimeout());
    }

    public int getStreamId() {
        return this.streamId;
    }
}

