/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.http;

import com.teskalabs.seacat.android.client.core.Reactor;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class InboundStream
extends InputStream {
    private final Reactor reactor;
    private int streamId = -1;
    private final BlockingQueue<ByteBuffer> frameQueue = new LinkedBlockingQueue<ByteBuffer>();
    private ByteBuffer currentFrame = null;
    private boolean closed = false;
    int readTimeoutMillis = 30000;
    private static final ByteBuffer QUEUE_IS_CLOSED = ByteBuffer.allocate(0);

    public InboundStream(Reactor reactor, int readTimeoutMillis) {
        this.reactor = reactor;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void setReadTimeout(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public boolean inboundData(ByteBuffer frame) {
        if (this.closed) {
            frame.clear();
            this.reactor.streamFactory.sendRST_STREAM(frame, this.reactor, this.streamId, 9);
            return false;
        }
        this.frameQueue.add(frame);
        return false;
    }

    protected ByteBuffer getCurrentFrame() throws SocketTimeoutException {
        long timeoutMillis;
        if (this.currentFrame != null) {
            if (this.currentFrame == QUEUE_IS_CLOSED) {
                return null;
            }
            if (this.currentFrame.remaining() == 0) {
                this.reactor.framePool.giveBack(this.currentFrame);
                this.currentFrame = null;
            } else {
                return this.currentFrame;
            }
        }
        if ((timeoutMillis = (long)this.readTimeoutMillis) == 0L) {
            timeoutMillis = 180000L;
        }
        long cutOfTimeMillis = System.nanoTime() / 1000000L + timeoutMillis;
        while (this.currentFrame == null) {
            try {
                long awaitMillis = cutOfTimeMillis - System.nanoTime() / 1000000L;
                if (awaitMillis <= 0L) {
                    throw new SocketTimeoutException(String.format("Read timeout: %d", this.readTimeoutMillis));
                }
                this.currentFrame = this.frameQueue.poll(awaitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            if (this.currentFrame != QUEUE_IS_CLOSED) continue;
            this.frameQueue.add(QUEUE_IS_CLOSED);
            this.currentFrame = null;
            break;
        }
        return this.currentFrame;
    }

    @Override
    public int read() throws IOException {
        ByteBuffer frame = this.getCurrentFrame();
        if (frame == null) {
            return -1;
        }
        return frame.get();
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        if (byteOffset < 0 || byteCount < 0 || byteOffset + byteCount > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer frame = this.getCurrentFrame();
        if (frame == null) {
            return -1;
        }
        if (byteCount > frame.remaining()) {
            byteCount = frame.remaining();
        }
        frame.get(buffer, byteOffset, byteCount);
        return byteCount;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.frameQueue.add(QUEUE_IS_CLOSED);
    }

    @Override
    public void reset() {
        this.frameQueue.add(QUEUE_IS_CLOSED);
        while (this.frameQueue.size() > 1) {
            ByteBuffer frame = (ByteBuffer)this.frameQueue.remove();
            if (frame == QUEUE_IS_CLOSED) continue;
            this.reactor.framePool.giveBack(frame);
        }
        if (this.currentFrame != null) {
            this.reactor.framePool.giveBack(this.currentFrame);
            this.currentFrame = null;
        }
        this.close();
    }

    protected void finalize() throws Throwable {
        if (this.currentFrame != null) {
            this.reactor.framePool.giveBack(this.currentFrame);
            this.currentFrame = null;
        }
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

