/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.hc;

import com.teskalabs.seacat.android.client.core.Reactor;
import com.teskalabs.seacat.android.client.core.SPDY;
import com.teskalabs.seacat.android.client.http.Headers;
import com.teskalabs.seacat.android.client.http.InboundStream;
import com.teskalabs.seacat.android.client.http.OutboundStream;
import com.teskalabs.seacat.android.client.intf.IFrameProvider;
import com.teskalabs.seacat.android.client.intf.IStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class SeaCatClientConnection
implements ClientConnectionRequest,
ManagedClientConnection,
IFrameProvider,
IStream {
    protected final Reactor reactor;
    protected HttpRequest request = null;
    protected HttpContext context = null;
    private int streamId = -1;
    private Lock streamIdLock = new ReentrantLock();
    private Condition streamIdCondition = this.streamIdLock.newCondition();
    protected final HttpRoute route;
    protected final HttpResponseFactory responseFactory;
    protected Object state;
    protected InboundStream inboundStream = null;
    protected OutboundStream outboundStream = null;
    private boolean alive = true;
    private int priority = 3;
    protected HttpResponse response = null;
    private Lock responseReadyLock = new ReentrantLock();
    private Condition responseReadyCondition = this.responseReadyLock.newCondition();
    private int socketTimeout = 300000;
    private boolean reusable = true;

    public SeaCatClientConnection(HttpRoute route, HttpResponseFactory responseFactory, Reactor reactor, Object state) {
        this.reactor = reactor;
        this.route = route;
        this.responseFactory = responseFactory;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFrameProvider.Result buildFrame(Reactor reactor) throws IOException {
        boolean fin_flag = this.outboundStream == null;
        ByteBuffer frame = reactor.framePool.borrow("SeaCatClientConnection.buildFrame");
        this.streamIdLock.lock();
        try {
            this.streamId = reactor.streamFactory.registerStream(this);
            this.streamIdCondition.signalAll();
        }
        finally {
            this.streamIdLock.unlock();
        }
        RequestLine requestLine = this.request.getRequestLine();
        Headers.Builder requestHeaders = new Headers.Builder();
        String host = this.request.getFirstHeader("Host").getValue();
        HeaderIterator iter = this.request.headerIterator();
        while (iter.hasNext()) {
            Header header = iter.nextHeader();
            requestHeaders.add(header.getName(), header.getValue());
        }
        requestHeaders.add("X-SC-SDK", "and");
        SPDY.buildALX1SynStream(frame, this.streamId, host, requestLine.getMethod(), requestLine.getUri(), requestHeaders.build(), fin_flag, this.priority);
        return new IFrameProvider.Result(frame, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStreamId() throws IOException {
        block9: {
            long timeoutMillis = this.getSocketTimeout();
            if (timeoutMillis == 0L) {
                timeoutMillis = 180000L;
            }
            long cutOfTimeMillis = System.nanoTime() / 1000000L + timeoutMillis;
            this.streamIdLock.lock();
            block5: while (true) {
                while (this.streamId == -1) {
                    long awaitMillis = cutOfTimeMillis - System.nanoTime() / 1000000L;
                    if (awaitMillis <= 0L) {
                        throw new SocketTimeoutException(String.format("Connect timeout: %d", timeoutMillis));
                    }
                    try {
                        this.streamIdCondition.awaitNanos(awaitMillis * 1000000L);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                break block9;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.streamIdLock.unlock();
            }
        }
    }

    @Override
    public int getFrameProviderPriority() {
        return this.priority;
    }

    public void open(HttpRoute httpRoute, HttpContext httpContext, HttpParams httpParams) throws IOException {
        this.context = httpContext;
    }

    public void close() throws IOException {
    }

    public void shutdown() throws IOException {
    }

    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        this.request = httpRequest;
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            this.outboundStream = new OutboundStream(this.reactor, this.priority);
        }
        this.reactor.registerFrameProvider(this, true);
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        HttpEntity e = httpEntityEnclosingRequest.getEntity();
        this.waitForStreamId();
        this.outboundStream.launch(this.streamId);
        e.writeTo((OutputStream)this.outboundStream);
        this.outboundStream.close();
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        long timeoutMillis = this.getSocketTimeout();
        if (timeoutMillis == 0L) {
            timeoutMillis = 180000L;
        }
        long cutOfTimeMillis = System.nanoTime() / 1000000L + timeoutMillis;
        HttpResponse resp = null;
        this.responseReadyLock.lock();
        try {
            while (this.response == null) {
                if (!this.alive) {
                    throw new HttpException("Request has been canceled.");
                }
                long awaitMillis = cutOfTimeMillis - System.nanoTime() / 1000000L;
                if (awaitMillis <= 0L) {
                    throw new SocketTimeoutException(String.format("Connect timeout: %d", timeoutMillis));
                }
                try {
                    this.responseReadyCondition.awaitNanos(awaitMillis * 1000000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            resp = this.response;
            this.response = null;
            return resp;
        }
        finally {
            this.responseReadyLock.unlock();
        }
    }

    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent((InputStream)this.inboundStream);
        response.setEntity((HttpEntity)entity);
    }

    public InetAddress getLocalAddress() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public InetAddress getRemoteAddress() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public boolean isStale() {
        return false;
    }

    public boolean isOpen() {
        return this.context != null;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void tunnelTarget(boolean b, HttpParams httpParams) throws IOException {
    }

    public void tunnelProxy(HttpHost httpHost, boolean b, HttpParams httpParams) throws IOException {
    }

    public void layerProtocol(HttpContext httpContext, HttpParams httpParams) throws IOException {
    }

    public void markReusable() {
        this.reusable = true;
    }

    public void unmarkReusable() {
        this.reusable = false;
    }

    public boolean isMarkedReusable() {
        return this.reusable;
    }

    public void setState(Object o) {
        this.state = o;
    }

    public Object getState() {
        return this.state;
    }

    public void setIdleDuration(long l, TimeUnit timeUnit) {
    }

    public void releaseConnection() throws IOException {
    }

    public void abortConnection() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResponseAvailable(int timeout) throws IOException {
        if (timeout == 0) {
            timeout = 180000;
        }
        long cutOfTimeMillis = System.nanoTime() / 1000000L + (long)timeout;
        this.responseReadyLock.lock();
        try {
            while (this.response == null) {
                if (!this.alive) {
                    boolean bl = false;
                    return bl;
                }
                long awaitMillis = cutOfTimeMillis - System.nanoTime() / 1000000L;
                if (awaitMillis <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.responseReadyCondition.awaitNanos(awaitMillis * 1000000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.responseReadyLock.unlock();
        }
        return this.response != null;
    }

    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    public boolean isSecure() {
        return true;
    }

    public HttpRoute getRoute() {
        return this.route;
    }

    public SSLSession getSSLSession() {
        return null;
    }

    public ManagedClientConnection getConnection(long l, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
        return this;
    }

    public void abortRequest() {
    }

    @Override
    public void reset() {
        this.responseReadyLock.lock();
        try {
            this.alive = false;
            this.responseReadyCondition.signalAll();
        }
        finally {
            this.responseReadyLock.unlock();
        }
        if (this.inboundStream != null) {
            this.inboundStream.reset();
        }
        if (this.outboundStream != null) {
            this.outboundStream.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean receivedALX1_SYN_REPLY(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        this.inboundStream = new InboundStream(reactor, this.getSocketTimeout());
        this.inboundStream.setStreamId(this.streamId);
        short responseCode = frame.getShort();
        ProtocolVersion pver = new ProtocolVersion("HTTP", 1, 1);
        HttpResponse resp = this.responseFactory.newHttpResponse(pver, (int)responseCode, this.context);
        frame.getShort();
        while (frame.position() < frame.limit()) {
            String k = SPDY.parseVLEString(frame);
            String v = SPDY.parseVLEString(frame);
            resp.addHeader(k, v);
        }
        this.responseReadyLock.lock();
        try {
            this.response = resp;
            this.responseReadyCondition.signalAll();
        }
        finally {
            this.responseReadyLock.unlock();
        }
        if ((frameFlags & 1) == 1) {
            this.inboundStream.close();
        }
        return true;
    }

    @Override
    public boolean receivedSPD3_RST_STREAM(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        this.reset();
        return true;
    }

    @Override
    public boolean receivedDataFrame(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        if (this.inboundStream == null) {
            return true;
        }
        boolean ret = this.inboundStream.inboundData(frame);
        if ((frameFlags & 1) == 1) {
            this.inboundStream.close();
        }
        return ret;
    }
}

