/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.core;

import android.util.Log;
import com.teskalabs.seacat.android.client.core.Reactor;
import com.teskalabs.seacat.android.client.core.SPDY;
import com.teskalabs.seacat.android.client.intf.ICntlFrameConsumer;
import com.teskalabs.seacat.android.client.intf.IFrameProvider;
import com.teskalabs.seacat.android.client.intf.IStream;
import com.teskalabs.seacat.android.client.util.IntegerCounter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class StreamFactory
implements ICntlFrameConsumer,
IFrameProvider {
    private final IntegerCounter streamIdSequence = new IntegerCounter(1);
    private final Map<Integer, IStream> streams = new HashMap<Integer, IStream>();
    private final BlockingQueue<ByteBuffer> outboundFrameQueue = new LinkedBlockingQueue<ByteBuffer>();

    protected StreamFactory() {
    }

    public synchronized int registerStream(IStream stream) {
        int streamId = this.streamIdSequence.getAndAdd(2);
        IStream prev = this.streams.put(streamId, stream);
        assert (prev == null);
        return streamId;
    }

    public synchronized void unregisterStream(int streamId) {
        this.streams.remove(streamId);
    }

    protected synchronized void reset() {
        for (Map.Entry<Integer, IStream> pairs : this.streams.entrySet()) {
            IStream stream = pairs.getValue();
            stream.reset();
        }
        this.streamIdSequence.set(1);
        this.streams.clear();
    }

    protected synchronized IStream getStream(int streamId) {
        return this.streams.get(streamId);
    }

    protected boolean receivedALX1_SYN_REPLY(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        int streamId = frame.getInt();
        IStream stream = this.getStream(streamId);
        if (stream == null) {
            Log.w((String)"SeaCat", (String)("receivedALX1_SYN_REPLY stream not found: " + streamId + " (can be closed already)"));
            frame.clear();
            this.sendRST_STREAM(frame, reactor, streamId, 2);
            return false;
        }
        boolean ret = stream.receivedALX1_SYN_REPLY(reactor, frame, frameLength, frameFlags);
        if ((frameFlags & 1) == 1) {
            this.unregisterStream(streamId);
        }
        return ret;
    }

    protected boolean receivedSPD3_RST_STREAM(Reactor reactor, ByteBuffer frame, int frameLength, byte frameFlags) {
        int streamId = frame.getInt();
        IStream stream = this.getStream(streamId);
        if (stream == null) {
            Log.w((String)"SeaCat", (String)("receivedSPD3_RST_STREAM stream not found: " + streamId + " (can be closed already)"));
            return true;
        }
        boolean ret = stream.receivedSPD3_RST_STREAM(reactor, frame, frameLength, frameFlags);
        this.unregisterStream(streamId);
        return ret;
    }

    public boolean receivedDataFrame(Reactor reactor, ByteBuffer frame) {
        int streamId = frame.getInt();
        IStream stream = this.getStream(streamId);
        if (stream == null) {
            Log.w((String)"SeaCat", (String)("receivedDataFrame stream not found: " + streamId + " (can be closed already)"));
            frame.clear();
            this.sendRST_STREAM(frame, reactor, streamId, 2);
            return false;
        }
        int frameLength = frame.getInt();
        byte frameFlags = (byte)(frameLength >> 24);
        boolean ret = stream.receivedDataFrame(reactor, frame, frameLength &= 0xFFFFFF, frameFlags);
        if ((frameFlags & 1) == 1) {
            this.unregisterStream(streamId);
        }
        return ret;
    }

    @Override
    public boolean receivedControlFrame(Reactor reactor, ByteBuffer frame, int frameVersionType, int frameLength, byte frameFlags) {
        switch (frameVersionType) {
            case 10551298: {
                return this.receivedALX1_SYN_REPLY(reactor, frame, frameLength, frameFlags);
            }
            case 196611: {
                return this.receivedSPD3_RST_STREAM(reactor, frame, frameLength, frameFlags);
            }
        }
        Log.e((String)"SeaCat", (String)("StreamFactory.receivedControlFrame cannot handle frame: " + frameVersionType));
        return true;
    }

    public void sendRST_STREAM(ByteBuffer frame, Reactor reactor, int streamId, int statusCode) {
        SPDY.buildSPD3RstStream(frame, streamId, statusCode);
        try {
            this.addOutboundFrame(frame, reactor);
        }
        catch (IOException e) {
            reactor.framePool.giveBack(frame);
            e.printStackTrace();
        }
    }

    private void addOutboundFrame(ByteBuffer frame, Reactor reactor) throws IOException {
        this.outboundFrameQueue.add(frame);
        reactor.registerFrameProvider(this, true);
    }

    @Override
    public IFrameProvider.Result buildFrame(Reactor reactor) {
        ByteBuffer frame = (ByteBuffer)this.outboundFrameQueue.poll();
        boolean keep = !this.outboundFrameQueue.isEmpty();
        return new IFrameProvider.Result(frame, keep);
    }

    @Override
    public int getFrameProviderPriority() {
        return 1;
    }
}

