/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.core;

import com.teskalabs.seacat.android.client.http.Headers;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;

public class SPDY {
    public static final int HEADER_SIZE = 8;
    public static final short CNTL_FRAME_VERSION_SPD3 = 3;
    public static final short CNTL_FRAME_VERSION_ALX1 = 161;
    public static final short CNTL_TYPE_SYN_STREAM = 1;
    public static final short CNTL_TYPE_SYN_REPLY = 2;
    public static final short CNTL_TYPE_RST_STREAM = 3;
    public static final short CNTL_TYPE_PING = 6;
    public static final short CNTL_TYPE_STATS_REQ = 161;
    public static final short CNTL_TYPE_STATS_REP = 162;
    public static final short CNTL_TYPE_CSR = 193;
    public static final short CNTL_TYPE_CERT_QUERY = 194;
    public static final short CNTL_TYPE_CERT = 195;
    public static final byte FLAG_FIN = 1;
    public static final byte FLAG_UNIDIRECTIONAL = 2;
    public static final byte FLAG_CSR_NOT_FOUND = -128;
    public static final int RST_STREAM_STATUS_INVALID_STREAM = 2;
    public static final int RST_STREAM_STATUS_STREAM_ALREADY_CLOSED = 9;

    public static void buildSPD3Ping(ByteBuffer frame, int pingId) {
        frame.putShort((short)-32765);
        frame.putShort((short)6);
        frame.putInt(4);
        frame.putInt(pingId);
    }

    public static void buildSPD3RstStream(ByteBuffer frame, int streamId, int statusCode) {
        frame.putShort((short)-32765);
        frame.putShort((short)3);
        frame.putInt(8);
        frame.putInt(streamId);
        frame.putInt(statusCode);
    }

    public static void buildALX1SynStream(ByteBuffer buffer, int streamId, URL url, String method, Headers headers, boolean fin_flag, int priority) {
        SPDY.buildALX1SynStream(buffer, streamId, url.getHost(), method, url.getFile(), headers, fin_flag, priority);
    }

    public static void buildALX1SynStream(ByteBuffer buffer, int streamId, String host, String method, String path, Headers headers, boolean fin_flag, int priority) {
        int lastPeriodPos;
        assert ((streamId & Integer.MIN_VALUE) == 0);
        buffer.putShort((short)-32607);
        buffer.putShort((short)1);
        buffer.putInt(67305985);
        buffer.putInt(streamId);
        buffer.putInt(0);
        buffer.put((byte)((priority & 7) << 5));
        buffer.put((byte)0);
        assert (buffer.position() == 18);
        if (host.endsWith(".seacat") && (lastPeriodPos = host.lastIndexOf(46)) > 0) {
            host = host.substring(0, lastPeriodPos);
        }
        SPDY.appendVLEString(buffer, host);
        SPDY.appendVLEString(buffer, method);
        SPDY.appendVLEString(buffer, path);
        for (int i = 0; i < headers.size(); ++i) {
            String value;
            String header = headers.name(i);
            if (header == null || header.equalsIgnoreCase("host") || header.equalsIgnoreCase("connection") || (value = headers.value(i)) == null) continue;
            SPDY.appendVLEString(buffer, header);
            SPDY.appendVLEString(buffer, value);
        }
        int flagLength = buffer.position() - 8;
        assert (flagLength < 0x1000000);
        buffer.putInt(4, flagLength |= (fin_flag ? 1 : 0) << 24);
    }

    public static void buildDataFrameFlagLength(ByteBuffer buffer, boolean fin_flag) {
        assert (buffer != null);
        int flagLength = buffer.position() - 8;
        assert (flagLength < 0x1000000);
        buffer.putInt(4, flagLength |= (fin_flag ? 1 : 0) << 24);
    }

    private static void appendVLEString(ByteBuffer buffer, String text) {
        byte[] bytes;
        try {
            bytes = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = new byte[]{63, 63, 63};
        }
        assert (bytes.length <= 65535);
        if (bytes.length >= 250) {
            buffer.put((byte)-1);
            buffer.putShort((short)bytes.length);
        } else {
            buffer.put((byte)bytes.length);
        }
        buffer.put(bytes);
    }

    public static String parseVLEString(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        if (length == 255) {
            length = buffer.getShort() & 0xFFFF;
        }
        assert (length >= 0);
        byte[] bytes = new byte[length];
        buffer.get(bytes, 0, length);
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "???";
        }
    }

    public static int buildFrameVersionType(short cntlFrameVersion, short cntlType) {
        int ret = cntlFrameVersion;
        ret <<= 16;
        return ret |= cntlType;
    }
}

