/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.core;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.teskalabs.seacat.android.client.SeaCatInternals;
import com.teskalabs.seacat.android.client.core.FramePool;
import com.teskalabs.seacat.android.client.core.SPDY;
import com.teskalabs.seacat.android.client.core.StreamFactory;
import com.teskalabs.seacat.android.client.core.seacatcc;
import com.teskalabs.seacat.android.client.intf.ICntlFrameConsumer;
import com.teskalabs.seacat.android.client.intf.IFrameProvider;
import com.teskalabs.seacat.android.client.ping.PingFactory;
import com.teskalabs.seacat.android.client.util.RC;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Reactor
extends ContextWrapper {
    public final FramePool framePool = new FramePool();
    private final Thread ccoreThread;
    final Lock eventLoopNotStartedlock = new ReentrantLock();
    final Condition eventLoopStartedCond = this.eventLoopNotStartedlock.newCondition();
    private boolean eventLoopStarted = false;
    private final Executor workerExecutor;
    public final PingFactory pingFactory;
    public final StreamFactory streamFactory;
    public final ConnectivityManager connectivityManager;
    private final Map<Integer, ICntlFrameConsumer> cntlFrameConsumers = new HashMap<Integer, ICntlFrameConsumer>();
    private final BlockingQueue<IFrameProvider> frameProviders;
    private String lastState;
    private String clientId = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    private String clientTag = "[AAAAAAAAAAAAAAAA]";
    static String packageName = null;

    public Reactor(Context context) throws IOException {
        super(context);
        if (packageName == null) {
            packageName = this.getPackageName();
        }
        this.ccoreThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Reactor._run();
            }
        });
        this.ccoreThread.setName("SeaCatCCoreThread");
        this.ccoreThread.setDaemon(true);
        this.workerExecutor = new ThreadPoolExecutor(0, 1000, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        File vardir = this.getDir("seacat", 0);
        int rc = seacatcc.init(packageName, SeaCatInternals.applicationIdSuffix, vardir.getAbsolutePath(), this);
        RC.checkAndThrowIOException("seacatcc.init", rc);
        this.lastState = seacatcc.state();
        Comparator<IFrameProvider> frameProvidersComparator = new Comparator<IFrameProvider>(){

            @Override
            public int compare(IFrameProvider p1, IFrameProvider p2) {
                int p2pri;
                int p1pri = p1.getFrameProviderPriority();
                if (p1pri < (p2pri = p2.getFrameProviderPriority())) {
                    return -1;
                }
                if (p1pri == p2pri) {
                    return 0;
                }
                return 1;
            }
        };
        this.frameProviders = new PriorityBlockingQueue<IFrameProvider>(11, frameProvidersComparator);
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.streamFactory = new StreamFactory();
        this.cntlFrameConsumers.put(SPDY.buildFrameVersionType((short)161, (short)2), this.streamFactory);
        this.cntlFrameConsumers.put(SPDY.buildFrameVersionType((short)3, (short)3), this.streamFactory);
        this.pingFactory = new PingFactory();
        this.cntlFrameConsumers.put(SPDY.buildFrameVersionType((short)3, (short)6), this.pingFactory);
        this.ccoreThread.start();
        this.eventLoopNotStartedlock.lock();
        while (!this.eventLoopStarted) {
            this.eventLoopStartedCond.awaitUninterruptibly();
        }
        this.eventLoopNotStartedlock.unlock();
    }

    public void shutdown() throws IOException {
        int rc = seacatcc.shutdown();
        RC.checkAndThrowIOException("seacatcc.shutdown", rc);
        while (true) {
            try {
                this.ccoreThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        if (this.ccoreThread.isAlive()) {
            throw new IOException(String.format("%s is still alive", this.ccoreThread.getName()));
        }
    }

    private static void _run() {
        int rc = seacatcc.run();
        if (rc != 0) {
            Log.e((String)"SeaCat", (String)String.format("return code %d in %s", rc, "seacatcc.run"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFrameProvider(IFrameProvider provider, boolean single) throws IOException {
        BlockingQueue<IFrameProvider> blockingQueue = this.frameProviders;
        synchronized (blockingQueue) {
            if (single && this.frameProviders.contains(provider)) {
                return;
            }
            this.frameProviders.add(provider);
        }
        int rc = seacatcc.yield('W');
        if (rc > 7900 && rc < 8000) {
            Log.w((String)"SeaCat", (String)String.format("return code %d in %s", rc, "seacatcc.yield"));
            rc = 0;
        }
        RC.checkAndThrowIOException("seacatcc.yield", rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer JNICallbackWriteReady() {
        try {
            ByteBuffer frame = null;
            Vector<IFrameProvider> providersToKeep = new Vector<IFrameProvider>();
            BlockingQueue<IFrameProvider> blockingQueue = this.frameProviders;
            synchronized (blockingQueue) {
                IFrameProvider provider;
                while (frame == null && (provider = (IFrameProvider)this.frameProviders.poll()) != null) {
                    IFrameProvider.Result res = provider.buildFrame(this);
                    frame = res.frame;
                    if (!res.keep) continue;
                    providersToKeep.add(provider);
                }
                if (!providersToKeep.isEmpty()) {
                    this.frameProviders.addAll(providersToKeep);
                }
            }
            if (frame != null) {
                frame.flip();
            }
            return frame;
        }
        catch (Exception e) {
            Log.e((String)"SeaCat", (String)"JNICallbackWriteReady:", (Throwable)e);
            return null;
        }
    }

    protected ByteBuffer JNICallbackReadReady() {
        try {
            return this.framePool.borrow("Reactor.JNICallbackReadReady");
        }
        catch (Exception e) {
            Log.e((String)"SeaCat", (String)"JNICallbackReadReady:", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void JNICallbackFrameReceived(ByteBuffer frame, int frame_len) {
        int pos = frame.position();
        frame.position(pos + frame_len);
        frame.flip();
        byte fb = frame.get(0);
        boolean giveBackFrame = true;
        try {
            giveBackFrame = ((long)fb & 0x80L) != 0L ? this.receivedControlFrame(frame) : this.streamFactory.receivedDataFrame(this, frame);
        }
        catch (Exception e) {
            Log.e((String)"SeaCat", (String)"JNICallbackFrameReceived:", (Throwable)e);
            giveBackFrame = true;
        }
        finally {
            if (giveBackFrame) {
                this.framePool.giveBack(frame);
            }
        }
    }

    protected void JNICallbackFrameReturn(ByteBuffer frame) {
        this.framePool.giveBack(frame);
    }

    protected void JNICallbackWorkerRequest(char workerCode) {
        switch (workerCode) {
            case 'P': {
                this.workerExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        seacatcc.ppkgen_worker();
                    }
                });
                break;
            }
            case 'C': {
                Runnable CSRWorker = SeaCatInternals.getCSRWorker();
                if (CSRWorker != null) {
                    this.workerExecutor.execute(CSRWorker);
                }
                Intent intent = SeaCatInternals.createIntent("mobi.seacat.client.intent.action.CSR_NEEDED");
                this.sendBroadcast(intent);
                break;
            }
            default: {
                Log.w((String)"SeaCat", (String)("Unknown worker requested: " + workerCode));
            }
        }
    }

    protected double JNICallbackEvLoopHeartBeat(double now) {
        this.pingFactory.heartBeat(now);
        this.framePool.heartBeat(now);
        if (this.lastState.charAt(0) == 'E' || this.lastState.charAt(0) == 'H' || this.lastState.charAt(0) == 'P' || this.lastState.charAt(0) == 'p' || this.lastState.charAt(0) == 'C') {
            boolean isConnected;
            NetworkInfo activeNetwork = this.connectivityManager.getActiveNetworkInfo();
            boolean bl = isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            if (!isConnected) {
                seacatcc.yield('d');
                this.sendBroadcast(SeaCatInternals.createIntent("mobi.seacat.client.intent.action.GWCONN_RESET"));
            }
        } else if (this.lastState.charAt(0) == 'n') {
            boolean isConnected;
            NetworkInfo activeNetwork = this.connectivityManager.getActiveNetworkInfo();
            boolean bl = isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            if (isConnected) {
                seacatcc.yield('Q');
            }
        }
        return 5.0;
    }

    protected void JNICallbackEvLoopStarted() {
        this.eventLoopNotStartedlock.lock();
        this.eventLoopStarted = true;
        this.eventLoopStartedCond.signalAll();
        this.eventLoopNotStartedlock.unlock();
        this.sendBroadcast(SeaCatInternals.createIntent("mobi.seacat.client.intent.action.EVLOOP_STARTED"));
    }

    protected void JNICallbackGWConnConnected() {
        this.sendBroadcast(SeaCatInternals.createIntent("mobi.seacat.client.intent.action.GWCONN_CONNECTED"));
    }

    protected void JNICallbackGWConnReset() {
        this.pingFactory.reset();
        this.streamFactory.reset();
        this.sendBroadcast(SeaCatInternals.createIntent("mobi.seacat.client.intent.action.GWCONN_RESET"));
    }

    protected void JNICallbackStateChanged(String state) {
        if (SeaCatInternals.logDebug) {
            Log.d((String)"SeaCat", (String)("State changed to " + state));
        }
        Intent intent = SeaCatInternals.createIntent("mobi.seacat.client.intent.action.STATE_CHANGED");
        intent.putExtra("SEACAT_STATE", state);
        intent.putExtra("SEACAT_PREV_STATE", this.lastState);
        this.sendBroadcast(intent);
        if (this.lastState.charAt(0) != 'C' && state.charAt(0) == 'C') {
            this.configureProxyServer();
        }
        this.lastState = state;
    }

    protected void JNICallbackClientIdChanged(String clientId, String clientTag) {
        this.clientId = clientId;
        this.clientTag = clientTag;
        Intent intent = SeaCatInternals.createIntent("mobi.seacat.client.intent.action.CLIENTID_CHANGED");
        intent.putExtra("SEACAT_CLIENT_ID", this.clientId);
        intent.putExtra("SEACAT_CLIENT_TAG", this.clientTag);
        this.sendBroadcast(intent);
    }

    public void broadcastState() {
        Intent intent = SeaCatInternals.createIntent("mobi.seacat.client.intent.action.STATE_CHANGED");
        intent.putExtra("SEACAT_STATE", seacatcc.state());
        intent.putExtra("SEACAT_PREV_STATE", this.lastState);
        this.sendBroadcast(intent);
    }

    private boolean receivedControlFrame(ByteBuffer frame) {
        int frameVersionType = frame.getInt() & Integer.MAX_VALUE;
        int frameLength = frame.getInt();
        byte frameFlags = (byte)(frameLength >> 24);
        if ((frameLength &= 0xFFFFFF) + 8 != frame.limit()) {
            Log.w((String)"SeaCat", (String)String.format("Incorrect frame received: %d %x %d %x - closing connection", frame.limit(), frameVersionType, frameLength, frameFlags));
            seacatcc.yield('d');
            return true;
        }
        ICntlFrameConsumer consumer = this.cntlFrameConsumers.get(frameVersionType);
        if (consumer == null) {
            Log.w((String)"SeaCat", (String)String.format("Unidentified Control frame received: %d %x %d %x", frame.limit(), frameVersionType, frameLength, frameFlags));
            return true;
        }
        return consumer.receivedControlFrame(this, frame, frameVersionType, frameLength, frameFlags);
    }

    protected void configureProxyServer() {
        SharedPreferences sp = this.getSharedPreferences("seacat_preferences", 0);
        String proxy_host = sp.getString("HTTPSProxyHost", "");
        String proxy_port = sp.getString("HTTPSProxyPort", "");
        if (proxy_host.isEmpty()) {
            proxy_host = System.getProperty("https.proxyHost", "");
            proxy_port = System.getProperty("https.proxyPort", "");
        }
        int rc = seacatcc.set_proxy_server_worker(proxy_host, proxy_port);
        RC.checkAndLogError("seacatcc.set_proxy_server_worker", rc);
    }

    public String getClientTag() {
        return this.clientTag;
    }

    public String getClientId() {
        return this.clientId;
    }

    public static void setPackageName(String packageName) {
        Reactor.packageName = packageName;
    }
}

