/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import com.teskalabs.seacat.android.client.core.seacatcc;
import com.teskalabs.seacat.android.client.util.RC;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONObject;

public class CSR {
    private Map<String, String> paramMap = new HashMap<String, String>();

    public void set(String name, String value) {
        this.paramMap.put(name, value);
    }

    public String get(String name) {
        return this.paramMap.get(name);
    }

    public String[] toStringArray() {
        int cnt = this.paramMap.size();
        String[] arr = new String[cnt * 2];
        int pos = 0;
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            arr[pos++] = entry.getKey();
            arr[pos++] = entry.getValue();
        }
        return arr;
    }

    public String getCountry() {
        return this.paramMap.get("C");
    }

    public void setCountry(String country) {
        this.paramMap.put("C", country);
    }

    public String getState() {
        return this.paramMap.get("ST");
    }

    public void setState(String state) {
        this.paramMap.put("ST", state);
    }

    public String getLocality() {
        return this.paramMap.get("L");
    }

    public void setLocality(String locality) {
        this.paramMap.put("L", locality);
    }

    public String getOrganization() {
        return this.paramMap.get("O");
    }

    public void setOrganization(String organization) {
        this.paramMap.put("O", organization);
    }

    public String getOrganizationUnit() {
        return this.paramMap.get("OU");
    }

    public void setOrganizationUnit(String organization_unit) {
        this.paramMap.put("OU", organization_unit);
    }

    public String getCommonName() {
        return this.paramMap.get("CN");
    }

    public void setCommonName(String common_name) {
        this.paramMap.put("CN", common_name);
    }

    public String getSurname() {
        return this.paramMap.get("SN");
    }

    public void setSurname(String surname) {
        this.paramMap.put("SN", surname);
    }

    public String getGivenName() {
        return this.paramMap.get("GN");
    }

    public void setGivenName(String given_name) {
        this.paramMap.put("GN", given_name);
    }

    public String getEmailAddress() {
        return this.paramMap.get("emailAddress");
    }

    public void setEmailAddress(String emailAddress) {
        this.paramMap.put("emailAddress", emailAddress);
    }

    public String getUniqueIdentifier() {
        return this.paramMap.get("UID");
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.paramMap.put("UID", uniqueIdentifier);
    }

    public void setUniqueIdentifier(Context context) {
        UUID deviceUuid = null;
        String androidId = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"android_id");
        if (androidId != null && !"9774d56d682e549c".equals(androidId)) {
            try {
                deviceUuid = UUID.nameUUIDFromBytes(androidId.getBytes("utf8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (deviceUuid == null) {
            Log.w((String)"SeaCat", (String)"Settings.Secure.ANDROID_ID get failed, using random UUID");
            deviceUuid = UUID.randomUUID();
        }
        this.setUniqueIdentifier(deviceUuid.toString().replaceAll("-", ""));
    }

    public void setData(String data) {
        this.set("description", data);
    }

    public void setJsonData(JSONObject jsonData) {
        this.setData(jsonData.toString());
    }

    public void submit() throws IOException {
        int rc = seacatcc.csrgen_worker(this.toStringArray());
        RC.checkAndThrowIOException("seacatcc.csrgen_worker", rc);
    }

    public static Runnable submitDefault() {
        return new Runnable(){

            @Override
            public void run() {
                CSR csr = new CSR();
                try {
                    csr.submit();
                }
                catch (IOException e) {
                    Log.e((String)"SeaCat", (String)"Exception in CSR.createDefault:", (Throwable)e);
                }
            }
        };
    }
}

