/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.cvio;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.ContextWrapper;
import android.media.Image;
import android.util.Log;
import com.teskalabs.cvio.CVIOSeaCatPlugin;
import com.teskalabs.cvio.VNCDelegate;
import com.teskalabs.cvio.cviojni;
import com.teskalabs.seacat.android.client.SeaCatClient;
import com.teskalabs.seacat.android.client.socket.SocketConfig;
import java.io.IOException;
import java.nio.ByteBuffer;

class VNCServer
extends ContextWrapper {
    private static final String TAG = VNCServer.class.getName();
    protected static CVIOSeaCatPlugin cvioSeaCatPlugin = null;
    private Thread mVNCThread = null;
    private final String socketFileName;
    private static final int port = 5900;

    public VNCServer(Context base, VNCDelegate delegate) {
        super(base);
        if (cvioSeaCatPlugin == null) {
            cvioSeaCatPlugin = new CVIOSeaCatPlugin(5900);
        }
        cviojni.jni_set_delegate(delegate);
        this.socketFileName = this.getDir("cvio", 0).getAbsolutePath() + "/s/vnc";
    }

    public void configureSeaCat() throws IOException {
        SeaCatClient.configureSocket(5900, SocketConfig.Domain.AF_UNIX, SocketConfig.Type.SOCK_STREAM, 0, this.socketFileName, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(final int screenWidth, final int screenHeight) {
        if (screenWidth < 0 || screenHeight < 0) {
            Log.e((String)TAG, (String)"Screen width/height is not specified");
            return false;
        }
        VNCServer vNCServer = this;
        synchronized (vNCServer) {
            while (true) {
                if (this.mVNCThread == null) {
                    if (this.mVNCThread != null) return true;
                    this.mVNCThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Log.d((String)TAG, (String)"VNC Server started");
                            int rc = cviojni.jni_run(VNCServer.this.socketFileName, screenWidth, screenHeight);
                            if (rc != 0) {
                                Log.w((String)TAG, (String)("VNC Server thread exited with rc: " + rc));
                            }
                            Log.i((String)TAG, (String)"VNC Server terminated");
                        }
                    });
                    this.mVNCThread.setName("cvioVNCThread");
                    this.mVNCThread.setDaemon(true);
                    this.mVNCThread.start();
                    return true;
                }
                int rc = cviojni.jni_shutdown();
                if (rc != 0) {
                    Log.w((String)TAG, (String)("jni_shutdown returned: " + rc));
                }
                try {
                    this.mVNCThread.join(5000L);
                    if (this.mVNCThread.isAlive()) {
                        Log.w((String)TAG, (String)(this.mVNCThread + " is still joining ..."));
                        continue;
                    }
                    this.mVNCThread = null;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.mVNCThread == null) {
            return;
        }
        VNCServer vNCServer = this;
        synchronized (vNCServer) {
            while (this.mVNCThread != null) {
                int rc = cviojni.jni_shutdown();
                if (rc != 0) {
                    Log.w((String)TAG, (String)("jni_shutdown returned: " + rc));
                }
                try {
                    this.mVNCThread.join(5000L);
                    if (this.mVNCThread.isAlive()) {
                        Log.w((String)TAG, (String)(this.mVNCThread + " is still joining ..."));
                        continue;
                    }
                    this.mVNCThread = null;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    public void imageReady() {
        cviojni.jni_image_ready();
    }

    @TargetApi(value=21)
    public void push(Image image, int pixelFormat) {
        Image.Plane[] planes = image.getPlanes();
        ByteBuffer b = planes[0].getBuffer();
        if (pixelFormat == 1) {
            cviojni.jni_push_pixels_rgba_8888(b, planes[0].getRowStride());
        } else if (pixelFormat == 4) {
            cviojni.jni_push_pixels_rgba_565(b, planes[0].getRowStride());
        } else {
            Log.e((String)TAG, (String)("Image reader acquired unsupported image format " + pixelFormat));
        }
    }
}

