/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.cvio;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import com.teskalabs.cvio.VNCDelegate;
import com.teskalabs.cvio.VNCServer;
import com.teskalabs.cvio.exceptions.CatVisionException;
import com.teskalabs.cvio.exceptions.CatVisionNotSupportedException;
import com.teskalabs.cvio.exceptions.MissingAPIKeyException;
import com.teskalabs.cvio.inapp.InAppInputManager;
import com.teskalabs.cvio.inapp.KeySym;
import com.teskalabs.seacat.android.client.CSR;
import com.teskalabs.seacat.android.client.SeaCatClient;
import com.teskalabs.seacat.android.client.message.JSONMessageTrigger;
import java.io.IOException;

public class CatVision
extends ContextWrapper
implements VNCDelegate {
    private static final String TAG = CatVision.class.getName();
    public static final String DEFAULT_CUSTOM_ID = "-DefaultCustomId-";
    private static final String PREFS_CUSTOM_ID_KEY = "customId";
    private static final String PREFS_NAME = "cvio.prefs";
    private double downscale = 0.0;
    private MediaProjectionManager mProjectionManager = null;
    private static MediaProjection sMediaProjection = null;
    private static Thread sCaptureThread = null;
    private ImageReader mImageReader = null;
    private Handler mHandler = null;
    private VirtualDisplay mVirtualDisplay = null;
    private int mDensity;
    private Display mDisplay = null;
    private int mRotation;
    private OrientationChangeCallback mOrientationChangeCallback = null;
    private final VNCServer vncServer;
    private final InAppInputManager inputManager;
    private final String APIKeyId;
    private String customId = "-DefaultCustomId-";
    private int mMediaProjectionPixelFormat = 1;
    static final int minAPILevel = 21;
    protected static CatVision instance = null;
    Runnable mPingRun = new Runnable(){

        @Override
        public void run() {
            try {
                SeaCatClient.ping();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"SeaCat ping", (Throwable)e);
            }
            finally {
                CatVision.this.mHandler.postDelayed(CatVision.this.mPingRun, 30000L);
            }
        }
    };

    public static CatVision initialize(Application app) {
        return CatVision.initialize(app, false);
    }

    public static synchronized CatVision initialize(Application app, boolean hasCustomId) {
        if (instance != null) {
            return instance;
        }
        try {
            instance = new CatVision(app, hasCustomId);
        }
        catch (CatVisionNotSupportedException e) {
            Log.d((String)TAG, (String)"CatVision.io SDK requires Android API level 21 and higher.");
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return instance;
    }

    public static CatVision getInstance() {
        return instance;
    }

    private CatVision(Application app, boolean hasCustomId) throws IOException, CatVisionException {
        super(app.getApplicationContext());
        if (Build.VERSION.SDK_INT < 21) {
            throw new CatVisionNotSupportedException("Can't initialize CatVision.io - The minimum supported API level is 21.");
        }
        this.APIKeyId = CatVision.getApplicationMetaData(app.getApplicationContext(), "cvio.api_key_id");
        if (this.APIKeyId == null) {
            throw new MissingAPIKeyException("CatVision.io API key (cvio.api_key_id) not provided. See https://docs.catvision.io/get-started/api-key.html");
        }
        if (hasCustomId) {
            this.customId = null;
        }
        this.vncServer = new VNCServer((Context)this, this);
        SeaCatClient.setPackageName("com.teskalabs.cvio");
        SeaCatClient.initialize(app.getApplicationContext(), new Runnable(){

            @Override
            public void run() {
                CatVision.this.submitCSR();
            }
        });
        this.inputManager = new InAppInputManager(app);
        this.vncServer.configureSeaCat();
    }

    synchronized void submitCSR() {
        if (this.customId == null) {
            Log.w((String)TAG, (String)"Custom Id is null, cannot submit CSR");
            return;
        }
        String state = SeaCatClient.getState();
        if (state.charAt(1) != 'C') {
            Log.w((String)TAG, (String)"SeaCat is not ready for CSR");
            return;
        }
        CSR csr = new CSR();
        csr.setOrganization(this.getPackageName());
        csr.setOrganizationUnit(this.APIKeyId);
        if (this.customId != DEFAULT_CUSTOM_ID) {
            csr.setUniqueIdentifier(this.customId);
        }
        try {
            csr.submit();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Submitting CSR", (Throwable)e);
        }
    }

    public void reset() throws IOException {
        SeaCatClient.reset();
    }

    public String getClientTag() {
        return SeaCatClient.getClientTag();
    }

    public String getClientId() {
        return SeaCatClient.getClientId();
    }

    public String getState() {
        return SeaCatClient.getState();
    }

    public void resetCustomId() {
        SharedPreferences sharedPref = this.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.remove(PREFS_CUSTOM_ID_KEY);
        editor.apply();
        this.customId = null;
        try {
            this.reset();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Client reset", (Throwable)e);
        }
    }

    public String getCustomId() {
        return this.customId;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
        SharedPreferences sharedPref = this.getSharedPreferences(PREFS_NAME, 0);
        if (sharedPref.contains(PREFS_CUSTOM_ID_KEY)) {
            if (!sharedPref.getString(PREFS_CUSTOM_ID_KEY, "").equals(customId)) {
                SharedPreferences.Editor editor = sharedPref.edit();
                editor.putString(PREFS_CUSTOM_ID_KEY, customId);
                editor.apply();
                try {
                    this.reset();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Reset identity", (Throwable)e);
                }
            } else {
                String state = SeaCatClient.getState();
                if (state.charAt(1) == 'C') {
                    this.submitCSR();
                    return;
                }
                Log.w((String)TAG, (String)("SeaCat client state: " + SeaCatClient.getState()));
            }
        } else {
            SharedPreferences.Editor editor = sharedPref.edit();
            editor.putString(PREFS_CUSTOM_ID_KEY, customId);
            editor.apply();
            this.submitCSR();
        }
    }

    public void requestStart(Activity activity, int requestCode) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.w((String)TAG, (String)"Can't run requestStart() due to a low API level. API level 21 or higher is required.");
            return;
        }
        this.mProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
        if (sCaptureThread == null) {
            sCaptureThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Looper.prepare();
                    CatVision.this.mHandler = new Handler();
                    Looper.loop();
                }
            });
            sCaptureThread.start();
        }
        try {
            SeaCatClient.connect();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"SeaCatClient expcetion", (Throwable)e);
        }
        activity.startActivityForResult(this.mProjectionManager.createScreenCaptureIntent(), requestCode);
    }

    public void stop() {
        if (sCaptureThread == null) {
            return;
        }
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT < 21) {
                    Log.w((String)TAG, (String)"Can't run shutdown() due to a low API level. API level 21 or higher is required.");
                    return;
                }
                if (sMediaProjection != null) {
                    sMediaProjection.stop();
                    try {
                        CatVision.this.mHandler.post((Runnable)new JSONMessageTrigger("cvio-capture-stopped"){

                            @Override
                            public void onPostExecute() {
                                Log.i((String)TAG, (String)("Trigger 'cvio-capture-stopped' result:" + this.getResponseBody().toString()));
                            }
                        }.put("ClientTag", CatVision.this.getClientTag()));
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Failed to trigger SeaCat event", (Throwable)e);
                    }
                }
            }
        });
        this.vncServer.shutdown();
        this.stopRepeatingPing();
    }

    public boolean isStarted() {
        return sMediaProjection != null;
    }

    public void onActivityResult(Activity activity, int resultCode, Intent data) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.w((String)TAG, (String)"Can't run onActivityResult due to a low API level. API level 21 or higher is required.");
            return;
        }
        sMediaProjection = this.mProjectionManager.getMediaProjection(resultCode, data);
        if (sMediaProjection != null) {
            try {
                this.mHandler.post((Runnable)new JSONMessageTrigger("cvio-capture-started").put("ClientTag", this.getClientTag()).put("AppId", this.getPackageName()));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to trigger SeaCat event", (Throwable)e);
            }
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            this.mDensity = metrics.densityDpi;
            this.mDisplay = activity.getWindowManager().getDefaultDisplay();
            if (this.downscale == 0.0) {
                this.downscale = this.mDensity < 280 ? 1.0 : (this.mDensity < 400 ? 2.0 : 4.0);
            }
            this.createVirtualDisplay();
            this.mOrientationChangeCallback = new OrientationChangeCallback((Context)this);
            if (this.mOrientationChangeCallback.canDetectOrientation()) {
                this.mOrientationChangeCallback.enable();
            }
            sMediaProjection.registerCallback((MediaProjection.Callback)new MediaProjectionStopCallback(), this.mHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int takeImage() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.w((String)TAG, (String)"Can't run takeImage() due to a low API level. API level 21 or higher is required.");
            return 1;
        }
        if (this.mImageReader == null) {
            return 0;
        }
        try (Image image = null;){
            image = this.mImageReader.acquireLatestImage();
            if (image != null) {
                this.vncServer.push(image, this.mMediaProjectionPixelFormat);
            }
        }
        return 0;
    }

    @TargetApi(value=21)
    private void createVirtualDisplay() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.w((String)TAG, (String)"Can't run createVirtualDisplay() due to a low API level. API level 21 or higher is required.");
            return;
        }
        Point size = new Point();
        this.mDisplay.getRealSize(size);
        int mWidth = (int)((double)size.x / this.downscale);
        int mHeight = (int)((double)size.y / this.downscale);
        this.vncServer.shutdown();
        this.vncServer.run(mWidth, mHeight);
        this.startRepeatingPing();
        int VIRTUAL_DISPLAY_FLAGS = 9;
        this.mImageReader = ImageReader.newInstance((int)mWidth, (int)mHeight, (int)this.mMediaProjectionPixelFormat, (int)2);
        this.mVirtualDisplay = sMediaProjection.createVirtualDisplay("cvio", mWidth, mHeight, this.mDensity, VIRTUAL_DISPLAY_FLAGS, this.mImageReader.getSurface(), null, this.mHandler);
        this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), this.mHandler);
    }

    protected void startRepeatingPing() {
        this.stopRepeatingPing();
        this.mPingRun.run();
    }

    void stopRepeatingPing() {
        this.mHandler.removeCallbacks(this.mPingRun);
    }

    @Override
    public void rfbKbdAddEventProc(boolean down, long keySymCode, String client) {
        KeySym ks = (KeySym)((Object)KeySym.lookup.get((int)keySymCode));
        this.inputManager.onKeyboardEvent(down, ks);
    }

    @Override
    public void rfbKbdReleaseAllKeysProc(String client) {
        Log.d((String)TAG, (String)("rfbKbdReleaseAllKeysProc: client:" + client));
    }

    @Override
    public void rfbPtrAddEventProc(int buttonMask, int x, int y, String client) {
        this.inputManager.onMouseEvent(buttonMask, (int)((double)x * this.downscale), (int)((double)y * this.downscale));
    }

    @Override
    public void rfbSetXCutTextProc(String text, String client) {
        Log.d((String)TAG, (String)("rfbSetXCutTextProc: text:" + text + " client:" + client));
    }

    @Override
    public int rfbNewClientHook(String client) {
        try {
            this.mHandler.post((Runnable)new JSONMessageTrigger("cvio-new-client").put("VNCClient", client).put("ClientTag", this.getClientTag()));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to trigger SeaCat event", (Throwable)e);
        }
        return 0;
    }

    public void overrideDownscaleFactor(double value) {
        this.downscale = value;
    }

    private static String getApplicationMetaData(Context context, String name) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return bundle.getString(name);
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Log.e((String)TAG, (String)("Unable to load application meta-data: " + e.getMessage()));
            return null;
        }
    }

    @TargetApi(value=21)
    private class OrientationChangeCallback
    extends OrientationEventListener {
        OrientationChangeCallback(Context context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOrientationChanged(int orientation) {
            if (Build.VERSION.SDK_INT < 21) {
                Log.w((String)TAG, (String)"Can't run onOrientationChanged due to a low API level. API level 21 or higher is required.");
                return;
            }
            OrientationChangeCallback orientationChangeCallback = this;
            synchronized (orientationChangeCallback) {
                int rotation = CatVision.this.mDisplay.getRotation();
                if (rotation != CatVision.this.mRotation) {
                    CatVision.this.mRotation = rotation;
                    try {
                        if (CatVision.this.mVirtualDisplay != null) {
                            CatVision.this.mVirtualDisplay.release();
                        }
                        if (CatVision.this.mImageReader != null) {
                            CatVision.this.mImageReader.setOnImageAvailableListener(null, null);
                        }
                        CatVision.this.createVirtualDisplay();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @TargetApi(value=21)
    private class MediaProjectionStopCallback
    extends MediaProjection.Callback {
        private MediaProjectionStopCallback() {
        }

        public void onStop() {
            CatVision.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT < 21) {
                        Log.w((String)TAG, (String)"Can't run MediaProjectionStopCallback.onStop() due to a low API level. API level 21 or higher is required.");
                        return;
                    }
                    if (CatVision.this.mVirtualDisplay != null) {
                        CatVision.this.mVirtualDisplay.release();
                    }
                    if (CatVision.this.mImageReader != null) {
                        CatVision.this.mImageReader.setOnImageAvailableListener(null, null);
                    }
                    if (CatVision.this.mOrientationChangeCallback != null) {
                        CatVision.this.mOrientationChangeCallback.disable();
                    }
                    sMediaProjection.unregisterCallback((MediaProjection.Callback)MediaProjectionStopCallback.this);
                    sMediaProjection = null;
                    CatVision.this.vncServer.shutdown();
                    CatVision.this.stopRepeatingPing();
                }
            });
        }
    }

    @TargetApi(value=21)
    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        public void onImageAvailable(ImageReader reader) {
            CatVision.this.vncServer.imageReady();
        }
    }
}

