/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.http;

import com.teskalabs.seacat.android.client.core.Reactor;
import com.teskalabs.seacat.android.client.core.SPDY;
import com.teskalabs.seacat.android.client.intf.IFrameProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class OutboundStream
extends OutputStream
implements IFrameProvider {
    private final Reactor reactor;
    private int streamId = -1;
    private BlockingQueue<ByteBuffer> frameQueue = new LinkedBlockingQueue<ByteBuffer>();
    private ByteBuffer currentFrame = null;
    private boolean closed = false;
    private int contentLength = 0;
    private int priority;
    int writeTimeoutMillis = 30000;

    public OutboundStream(Reactor reactor, int priority) {
        this.reactor = reactor;
        this.priority = priority;
    }

    public void launch(int streamId) throws IOException {
        if (this.streamId != -1) {
            throw new IOException("OutputStream is already launched");
        }
        this.streamId = streamId;
        this.reactor.registerFrameProvider(this, true);
    }

    private synchronized ByteBuffer getCurrentFrame() throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream is already closed");
        }
        if (this.currentFrame == null) {
            this.currentFrame = this.reactor.framePool.borrow("HttpOutputStream.getCurrentFrame");
            this.currentFrame.position(8);
        }
        return this.currentFrame;
    }

    private synchronized void flushCurrentFrame(boolean fin_flag) throws IOException {
        assert (this.currentFrame != null);
        assert (fin_flag == this.closed);
        ByteBuffer aFrame = this.currentFrame;
        this.currentFrame = null;
        SPDY.buildDataFrameFlagLength(aFrame, fin_flag);
        long timeoutMillis = this.writeTimeoutMillis;
        if (timeoutMillis == 0L) {
            timeoutMillis = 180000L;
        }
        long cutOfTimeMillis = System.nanoTime() / 1000000L + timeoutMillis;
        boolean res = false;
        while (!res) {
            long awaitMillis = cutOfTimeMillis - System.nanoTime() / 1000000L;
            if (awaitMillis <= 0L) {
                throw new SocketTimeoutException(String.format("Write timeout: %d", this.writeTimeoutMillis));
            }
            try {
                res = this.frameQueue.offer(aFrame, awaitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.streamId != -1) {
            this.reactor.registerFrameProvider(this, true);
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream is already closed");
        }
        ByteBuffer frame = this.getCurrentFrame();
        if (frame == null) {
            throw new IOException("Frame not available");
        }
        frame.put((byte)oneByte);
        ++this.contentLength;
        if (frame.remaining() == 0) {
            this.flushCurrentFrame(false);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.closed) {
            return;
        }
        if (this.currentFrame == null) {
            this.getCurrentFrame();
        }
        this.closed = true;
        this.flushCurrentFrame(true);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.currentFrame != null) {
            this.flushCurrentFrame(false);
        }
    }

    public void reset() {
        this.closed = true;
        while (!this.frameQueue.isEmpty()) {
            ByteBuffer frame = (ByteBuffer)this.frameQueue.remove();
            this.reactor.framePool.giveBack(frame);
        }
        if (this.currentFrame != null) {
            this.reactor.framePool.giveBack(this.currentFrame);
            this.currentFrame = null;
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public IFrameProvider.Result buildFrame(Reactor reactor) throws IOException {
        boolean keep = false;
        assert (this.streamId > 0);
        ByteBuffer frame = (ByteBuffer)this.frameQueue.poll();
        if (frame != null) {
            frame.putInt(0, this.streamId);
            boolean bl = keep = !this.frameQueue.isEmpty();
            if ((frame.getShort(4) & 1) == 1) assert (!keep);
        }
        return new IFrameProvider.Result(frame, keep);
    }

    @Override
    public int getFrameProviderPriority() {
        return this.priority;
    }
}

