/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import com.teskalabs.seacat.android.client.core.seacatcc;
import com.teskalabs.seacat.android.client.util.RC;
import java.util.ArrayList;
import java.util.Properties;

public abstract class SeaCatPlugin {
    private static ArrayList<SeaCatPlugin> plugins = new ArrayList();
    private static boolean characteristicsCommited = false;

    static synchronized void commitCharacteristics(Context context) {
        if (characteristicsCommited) {
            throw new RuntimeException("SeaCat characteristics are already comited!");
        }
        ArrayList<String> chrs = new ArrayList<String>();
        for (SeaCatPlugin p : plugins) {
            Properties pchrs = p.getCharacteristics();
            if (pchrs == null) continue;
            for (String name : pchrs.stringPropertyNames()) {
                chrs.add(String.format("%s\u001f%s", name, pchrs.getProperty(name)));
            }
        }
        chrs.add(String.format("%s\u001f%s", "plv", Build.VERSION.RELEASE));
        chrs.add(String.format("%s\u001f%s", "pls", Build.VERSION.SDK_INT));
        chrs.add(String.format("%s\u001f%s", "pli", Build.VERSION.INCREMENTAL));
        chrs.add(String.format("%s\u001f%s", "plB", Build.BRAND));
        chrs.add(String.format("%s\u001f%s", "plf", Build.FINGERPRINT));
        chrs.add(String.format("%s\u001f%s", "plI", Build.ID));
        chrs.add(String.format("%s\u001f%s", "plm", Build.MANUFACTURER));
        chrs.add(String.format("%s\u001f%s", "plM", Build.MODEL));
        chrs.add(String.format("%s\u001f%s", "plp", Build.PRODUCT));
        chrs.add(String.format("%s\u001f%s", "plt", Build.TAGS));
        chrs.add(String.format("%s\u001f%s", "plT", Build.TYPE));
        chrs.add(String.format("%s\u001f%s", "plU", Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id")));
        chrs.add(String.format("%s\u001f%s", "hwb", Build.BOARD));
        chrs.add(String.format("%s\u001f%s", "hwd", Build.DEVICE));
        chrs.add(String.format("%s\u001f%s", "hwS", Build.SERIAL));
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        chrs.add(String.format("%s\u001f%sx%s", "dpr", dm.widthPixels, dm.heightPixels));
        chrs.add(String.format("%s\u001f%s", "dpi", dm.densityDpi));
        chrs.add(String.format("%s\u001f%s", "dpden", Float.valueOf(dm.density)));
        chrs.add(String.format("%s\u001f%s", "dpxdpi", Float.valueOf(dm.xdpi)));
        chrs.add(String.format("%s\u001f%s", "dpydpi", Float.valueOf(dm.ydpi)));
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            chrs.add(String.format("%s\u001f%s", "apN", pInfo.versionName));
            chrs.add(String.format("%s\u001f%s", "apV", pInfo.versionCode));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"SeaCat", (String)"Cannot get package info of the application");
        }
        chrs.add(null);
        String[] chrsarr = new String[chrs.size()];
        chrsarr = chrs.toArray(chrsarr);
        int rc = seacatcc.characteristics_store(chrsarr);
        RC.checkAndLogError("seacatcc.characteristics_store", rc);
        if (rc == 0) {
            characteristicsCommited = true;
        }
    }

    public SeaCatPlugin() {
        plugins.add(this);
    }

    public abstract Properties getCharacteristics();
}

