/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.cvio.inapp;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import com.teskalabs.cvio.inapp.KeySym;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InAppInputManager
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = InAppInputManager.class.getName();
    private final Object currentActivityLock = new Object();
    private WeakReference<Activity> currentActivity = null;
    private boolean button1Pressed = false;
    private int metaState = 0;

    public InAppInputManager(Application app) {
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    private View obtainTargetView() {
        Activity a = this.obtainActivity();
        if (a == null) {
            return null;
        }
        View v = a.findViewById(0x1020002).getRootView();
        if (v == null) {
            return null;
        }
        if (v.hasWindowFocus()) {
            return v;
        }
        List<View> lv = InAppInputManager.getWindowManagerViews();
        for (View vi : lv) {
            if (!vi.hasWindowFocus()) continue;
            return vi;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Activity obtainActivity() {
        Object object = this.currentActivityLock;
        synchronized (object) {
            if (this.currentActivity == null) {
                return null;
            }
            return (Activity)this.currentActivity.get();
        }
    }

    public void onMouseEvent(int buttonMask, int x, int y) {
        if (!this.button1Pressed && (buttonMask & 1) != 0) {
            this.injectTouchEvent(1, 0, x, y);
            this.button1Pressed = true;
        } else if (this.button1Pressed) {
            if ((buttonMask & 1) == 0) {
                this.injectTouchEvent(1, 1, x, y);
                this.button1Pressed = false;
            } else {
                this.injectTouchEvent(1, 2, x, y);
            }
        }
    }

    private void injectTouchEvent(int buttonId, int event, int x, int y) {
        final View view = this.obtainTargetView();
        if (view == null) {
            return;
        }
        Activity activity = this.obtainActivity();
        if (activity == null) {
            return;
        }
        int[] viewLocation = new int[2];
        view.getLocationOnScreen(viewLocation);
        MotionEvent.PointerProperties pp = new MotionEvent.PointerProperties();
        pp.toolType = 1;
        pp.id = 0;
        MotionEvent.PointerProperties[] pps = new MotionEvent.PointerProperties[]{pp};
        MotionEvent.PointerCoords pc = new MotionEvent.PointerCoords();
        pc.size = 1.0f;
        pc.pressure = 1.0f;
        pc.x = x - viewLocation[0];
        pc.y = y - viewLocation[1];
        MotionEvent.PointerCoords[] pcs = new MotionEvent.PointerCoords[]{pc};
        long t = SystemClock.uptimeMillis();
        final MotionEvent e = MotionEvent.obtain((long)t, (long)(t + 100L), (int)event, (int)pps.length, (MotionEvent.PointerProperties[])pps, (MotionEvent.PointerCoords[])pcs, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)1, (int)0, (int)4098, (int)0);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                view.dispatchTouchEvent(e);
            }
        });
    }

    public void onKeyboardEvent(boolean down, KeySym ks) {
        if (ks == KeySym.XK_Escape && (this.metaState & 0xC0) != 0) {
            if (!down) {
                return;
            }
            this.injectBackEvent();
            return;
        }
        if (ks.keyeventCode != -1) {
            this.injectKeyboardEvent(down, ks);
            if (ks.metaState != 0) {
                this.metaState = down ? (this.metaState |= ks.metaState) : (this.metaState &= ~ks.metaState);
            }
            return;
        }
        Log.i((String)TAG, (String)("onKeyboardEvent: down:" + down + " keySym:" + (Object)((Object)ks)));
    }

    private void injectKeyboardEvent(boolean down, KeySym ks) {
        final View view = this.obtainTargetView();
        if (view == null) {
            return;
        }
        Activity activity = this.obtainActivity();
        if (activity == null) {
            return;
        }
        long t = SystemClock.uptimeMillis();
        int action = 1;
        if (down) {
            action = 0;
        }
        final KeyEvent e = new KeyEvent(t, t + 100L, action, ks.keyeventCode, 0, this.metaState, 0, 0);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                view.dispatchKeyEvent(e);
            }
        });
    }

    private void injectBackEvent() {
        final Activity activity = this.obtainActivity();
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                activity.onBackPressed();
            }
        });
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityStarted(Activity activity) {
        Log.i((String)TAG, (String)("onActivityStarted:" + activity));
        Object object = this.currentActivityLock;
        synchronized (object) {
            this.currentActivity = new WeakReference<Activity>(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResumed(Activity activity) {
        Log.i((String)TAG, (String)("onActivityResumed:" + activity));
        Object object = this.currentActivityLock;
        synchronized (object) {
            this.currentActivity = new WeakReference<Activity>(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityPaused(Activity activity) {
        Log.i((String)TAG, (String)("onActivityPaused:" + activity));
        Object object = this.currentActivityLock;
        synchronized (object) {
            if (this.currentActivity != null && this.currentActivity.get() == activity) {
                this.currentActivity = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityStopped(Activity activity) {
        Log.i((String)TAG, (String)("onActivityStopped:" + activity));
        Object object = this.currentActivityLock;
        synchronized (object) {
            if (this.currentActivity != null && this.currentActivity.get() == activity) {
                this.currentActivity = null;
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private static List<View> getWindowManagerViews() {
        try {
            if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
                Class<?> wmiClass = Class.forName("android.view.WindowManagerImpl");
                Object wmiInstance = wmiClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
                return InAppInputManager.viewsFromWM(wmiClass, wmiInstance);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                Class<?> wmgClass = Class.forName("android.view.WindowManagerGlobal");
                Object wmgInstance = wmgClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                return InAppInputManager.viewsFromWM(wmgClass, wmgInstance);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<View>();
    }

    private static List<View> viewsFromWM(Class wmClass, Object wmInstance) throws Exception {
        Field viewsField = wmClass.getDeclaredField("mViews");
        viewsField.setAccessible(true);
        Object views = viewsField.get(wmInstance);
        if (views instanceof List) {
            return (List)viewsField.get(wmInstance);
        }
        if (views instanceof View[]) {
            return Arrays.asList((View[])viewsField.get(wmInstance));
        }
        return new ArrayList<View>();
    }
}

