/*
 * Decompiled with CFR 0.152.
 */
package com.teskalabs.seacat.android.client.ping;

import android.util.Log;
import com.teskalabs.seacat.android.client.core.Reactor;
import com.teskalabs.seacat.android.client.core.SPDY;
import com.teskalabs.seacat.android.client.intf.ICntlFrameConsumer;
import com.teskalabs.seacat.android.client.intf.IFrameProvider;
import com.teskalabs.seacat.android.client.ping.Ping;
import com.teskalabs.seacat.android.client.ping.Pong;
import com.teskalabs.seacat.android.client.util.IntegerCounter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class PingFactory
implements ICntlFrameConsumer,
IFrameProvider {
    private final IntegerCounter idSequence = new IntegerCounter(1);
    private final BlockingQueue<Ping> outboundPingQueue = new LinkedBlockingQueue<Ping>();
    private final Map<Integer, Ping> waitingPingDict = new HashMap<Integer, Ping>();

    public synchronized void ping(Reactor reactor, Ping ping) throws IOException {
        this.outboundPingQueue.add(ping);
        reactor.registerFrameProvider(this, true);
    }

    public synchronized void reset() {
        this.idSequence.set(1);
        Iterator<Map.Entry<Integer, Ping>> it = this.waitingPingDict.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Ping> entry = it.next();
            Ping ping = entry.getValue();
            it.remove();
            ping.cancel();
        }
    }

    public synchronized void heartBeat(double now) {
        Iterator<Map.Entry<Integer, Ping>> it = this.waitingPingDict.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Ping> entry = it.next();
            Ping ping = entry.getValue();
            if (!ping.isExpired(now)) continue;
            it.remove();
            ping.cancel();
        }
        it = this.outboundPingQueue.iterator();
        while (it.hasNext()) {
            Ping ping = (Ping)((Object)it.next());
            if (!ping.isExpired(now)) continue;
            it.remove();
            ping.cancel();
        }
    }

    @Override
    public synchronized IFrameProvider.Result buildFrame(Reactor reactor) throws IOException {
        ByteBuffer frame = null;
        Ping ping = (Ping)this.outboundPingQueue.poll();
        if (ping == null) {
            return new IFrameProvider.Result(null, false);
        }
        if (!(ping instanceof Pong)) {
            ping.setPingId(this.idSequence.getAndAdd(2));
            this.waitingPingDict.put(ping.pingId, ping);
        }
        frame = reactor.framePool.borrow("PingFactory.ping");
        SPDY.buildSPD3Ping(frame, ping.pingId);
        return new IFrameProvider.Result(frame, !this.outboundPingQueue.isEmpty());
    }

    @Override
    public synchronized boolean receivedControlFrame(Reactor reactor, ByteBuffer frame, int frameVersionType, int frameLength, byte frameFlags) {
        int pingId = frame.getInt();
        if (pingId % 2 == 1) {
            Ping ping = this.waitingPingDict.remove(pingId);
            if (ping != null) {
                ping.pong();
            } else {
                Log.w((String)"SeaCat", (String)("received pong with unknown id: " + pingId));
            }
        } else {
            this.outboundPingQueue.add(new Pong(pingId));
            try {
                reactor.registerFrameProvider(this, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public int getFrameProviderPriority() {
        return 0;
    }
}

